/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.shaderobjects;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.shader.BufferNameUtil;
import com.ventooth.swansong.shader.CompositeTextureData;
import com.ventooth.swansong.shader.ShaderSamplers;
import com.ventooth.swansong.shader.loader.CompiledProgram;
import com.ventooth.swansong.shader.loader.IShaderPool;
import com.ventooth.swansong.shader.shaderobjects.ManagedShader;
import com.ventooth.swansong.shader.uniform.GeneralUniforms;
import com.ventooth.swansong.shader.uniform.Uniform;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

public class CompositeShader
extends ManagedShader {
    private static final List<Uniform<?>> RELEVANT_UNIFORMS = GeneralUniforms.getWith(ShaderSamplers.Composite.uniforms());
    private final Set<CompositeTextureData> mipmapEnabled;

    public CompositeShader(ResourceLocation loc, CompiledProgram prog) {
        super(loc, prog);
        EnumSet<CompositeTextureData> mipmapEnabled = EnumSet.noneOf(CompositeTextureData.class);
        for (String name : prog.mipmapEnabled()) {
            CompositeTextureData index = BufferNameUtil.gbufferIndexFromName(name);
            if (index == null) {
                Share.log.debug("{} bad mipmap setting: {}MipmapEnabled", new Object[]{loc, name});
                continue;
            }
            mipmapEnabled.add(index);
            Share.log.trace("{}->{}MipmapEnabled:{}", new Object[]{loc, name, index});
        }
        this.mipmapEnabled = mipmapEnabled.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(mipmapEnabled);
    }

    @Contract(value="_,_,true->!null")
    public static CompositeShader load(IShaderPool pool, ResourceLocation loc, boolean essential) {
        CompiledProgram shader = pool.borrowShader(loc, essential);
        if (shader == null) {
            if (essential) {
                throw new NullPointerException("Failed to load essential shader: " + loc);
            }
            return null;
        }
        return new CompositeShader(loc, shader);
    }

    @Override
    protected List<Uniform<?>> relevantUniforms() {
        return RELEVANT_UNIFORMS;
    }

    @Generated
    public Set<CompositeTextureData> mipmapEnabled() {
        return this.mipmapEnabled;
    }
}

