/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.texbuf;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.shader.BufferNameUtil;
import com.ventooth.swansong.shader.CompositeTextureData;
import com.ventooth.swansong.shader.DrawBuffers;
import com.ventooth.swansong.shader.texbuf.BufferConfig;
import com.ventooth.swansong.sufrace.FramebufferAttachment;
import com.ventooth.swansong.sufrace.Texture2D;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.lwjgl.opengl.GL11;

public class ColorBuffers {
    private final EnumSet<CompositeTextureData> clear;
    private final Map<CompositeTextureData, Texture2D> textures;
    private boolean deinited = false;

    public ColorBuffers(@NotNull Map<CompositeTextureData, BufferConfig> configs, @NotNull String namePrefix, int width, int height) {
        EnumMap<CompositeTextureData, Texture2D> textures = new EnumMap<CompositeTextureData, Texture2D>(CompositeTextureData.class);
        EnumSet<CompositeTextureData> clear = EnumSet.noneOf(CompositeTextureData.class);
        for (Map.Entry<CompositeTextureData, BufferConfig> entry : configs.entrySet()) {
            CompositeTextureData id = entry.getKey();
            BufferConfig config = entry.getValue();
            String name = namePrefix + config.name;
            textures.put(id, Texture2D.ofColorDrawBuffer(name, width, height, config.format));
            if (config.clear) {
                clear.add(id);
            }
            Share.log.trace("Created Color Draw Buffer: {}, format {}", new Object[]{name, BufferNameUtil.gbufferFormatNameFromEnum(config.format)});
        }
        this.clear = clear;
        this.textures = Collections.unmodifiableMap(textures);
    }

    public void deinit() {
        if (this.deinited) {
            return;
        }
        this.deinited = true;
        this.textures.values().forEach(Texture2D::deinit);
    }

    public Texture2D get(CompositeTextureData id) {
        return this.textures.get((Object)id);
    }

    public void resize(int width, int height) {
        for (Texture2D texture : this.textures.values()) {
            texture.resize(width, height);
        }
    }

    public Map<FramebufferAttachment, Texture2D> getFramebufferAttachments(IntList indices) {
        EnumMap<FramebufferAttachment, Texture2D> result = new EnumMap<FramebufferAttachment, Texture2D>(FramebufferAttachment.class);
        IntIterator iter = indices.intIterator();
        int i = 0;
        while (iter.hasNext()) {
            int index = iter.nextInt();
            CompositeTextureData id = DrawBuffers.textureFromColorTexIndex(index);
            Texture2D tex = this.textures.get((Object)id);
            if (tex == null) {
                throw new IllegalArgumentException("Color buffer with index " + index + " not found!");
            }
            FramebufferAttachment attachment = FramebufferAttachment.fromColorIndex(i);
            if (attachment == null) {
                throw new IllegalArgumentException("Invalid framebuffer color attachment index " + i);
            }
            result.put(attachment, tex);
            ++i;
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<CompositeTextureData, Texture2D> getAllTextures() {
        return this.textures;
    }

    public void clear(Vector3dc fogColor) {
        if (this.deinited) {
            throw new IllegalStateException("Cannot clear deinited color textures!");
        }
        block4: for (Map.Entry<CompositeTextureData, Texture2D> tex : this.textures.entrySet()) {
            CompositeTextureData id = tex.getKey();
            Texture2D texture = tex.getValue();
            if (!this.clear.contains((Object)id)) continue;
            switch (id) {
                case colortex0: {
                    this.clearBuffer(texture, (float)fogColor.x(), (float)fogColor.y(), (float)fogColor.z(), 1.0f);
                    continue block4;
                }
                case colortex1: {
                    this.clearBuffer(texture, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block4;
                }
            }
            this.clearBuffer(texture, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    private void clearBuffer(Texture2D texture, float r, float g, float b, float a) {
        texture.attachToFramebufferColor(36064);
        GL11.glClearColor((float)r, (float)g, (float)b, (float)a);
        GL11.glClear((int)16384);
    }
}

