/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.uniform;

import com.falsepattern.lib.util.FileUtil;
import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.DebugConfig;
import com.ventooth.swansong.shader.info.ShaderVar;
import com.ventooth.swansong.shader.uniform.CompiledUniform;
import com.ventooth.swansong.shader.uniform.Uniform;
import com.ventooth.swansong.uniforms.Builtins;
import com.ventooth.swansong.uniforms.StatefulBuiltins;
import com.ventooth.swansong.uniforms.UniformFunction;
import com.ventooth.swansong.uniforms.UniformFunctionRegistry;
import com.ventooth.swansong.uniforms.compiler.UniformCompiler;
import com.ventooth.swansong.uniforms.compiler.backend.BytecodeOptimizer;
import com.ventooth.swansong.uniforms.compiler.backend.CodeGenerator;
import com.ventooth.swansong.uniforms.compiler.frontend.Optimizer;
import com.ventooth.swansong.uniforms.compiler.frontend.TypeResolver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2dc;
import org.joml.Vector3dc;
import org.joml.Vector4dc;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CompiledUniforms {
    private final Map<String, CompiledUniform> uniforms;
    private final InternalCompiledUniform carrier;
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Map<com.ventooth.swansong.uniforms.Type, String> uniformTypeInternalNameMap = new EnumMap<com.ventooth.swansong.uniforms.Type, String>(com.ventooth.swansong.uniforms.Type.class);
    private static final String internalInterfaceName = Type.getInternalName(InternalCompiledUniform.class);

    public List<Uniform<?>> wrapUniforms() {
        ArrayList<Uniform> list = new ArrayList<Uniform>();
        for (Map.Entry<String, CompiledUniform> entry : this.uniforms.entrySet()) {
            String name = entry.getKey();
            CompiledUniform rawGetter = entry.getValue();
            if (rawGetter instanceof CompiledUniform.Float) {
                CompiledUniform.Float getter = (CompiledUniform.Float)rawGetter;
                list.add(new Uniform.OfDouble(name, getter::value, Uniform::set));
                continue;
            }
            if (rawGetter instanceof CompiledUniform.Int) {
                CompiledUniform.Int getter = (CompiledUniform.Int)rawGetter;
                list.add(new Uniform.OfInt(name, getter::value, Uniform::set));
                continue;
            }
            if (rawGetter instanceof CompiledUniform.Bool) {
                CompiledUniform.Bool getter = (CompiledUniform.Bool)rawGetter;
                list.add(new Uniform.OfBoolean(name, getter::value, Uniform::set));
                continue;
            }
            if (rawGetter instanceof CompiledUniform.Vec2) {
                CompiledUniform.Vec2 getter = (CompiledUniform.Vec2)rawGetter;
                list.add(new Uniform.Of<Vector2dc>(name, getter::value, Uniform::set));
                continue;
            }
            if (rawGetter instanceof CompiledUniform.Vec3) {
                CompiledUniform.Vec3 getter = (CompiledUniform.Vec3)rawGetter;
                list.add(new Uniform.Of<Vector3dc>(name, getter::value, Uniform::set));
                continue;
            }
            if (!(rawGetter instanceof CompiledUniform.Vec4)) continue;
            CompiledUniform.Vec4 getter = (CompiledUniform.Vec4)rawGetter;
            list.add(new Uniform.Of<Vector4dc>(name, getter::value, Uniform::set));
        }
        return Collections.unmodifiableList(list);
    }

    public void update() {
        this.carrier.update();
        StatefulBuiltins.update();
    }

    public static CompiledUniforms createCompiledUniforms(UniformFunctionRegistry mcUniforms, List<ShaderVar> shaderVars) {
        HashMap<String, CompiledUniform> accessorInstances;
        InternalCompiledUniform carrierInstance;
        UniformFunctionRegistry.Single varRegistry = new UniformFunctionRegistry.Single();
        UniformFunctionRegistry.Multi registry = new UniformFunctionRegistry.Multi();
        registry.add(Builtins.REGISTRY);
        registry.add(StatefulBuiltins.REGISTRY);
        registry.add(varRegistry);
        registry.add(mcUniforms);
        ClassNode carrier = new ClassNode();
        carrier.version = 52;
        carrier.superName = "java/lang/Object";
        carrier.interfaces.add(internalInterfaceName);
        carrier.name = "com/ventooth/swansong/shader/uniform/compiled/__COMP_CARRIER_" + counter.incrementAndGet();
        carrier.access = 1;
        CompiledUniforms.addEmptyConstructor(carrier);
        MethodNode updateMethod = new MethodNode(1, "update", "()V", null, null);
        carrier.methods.add(updateMethod);
        HashMap<String, ClassNode> accessors = new HashMap<String, ClassNode>();
        UniformCompiler compiler = new UniformCompiler(new UniformCompiler.Flags(new TypeResolver.Flags(true), new Optimizer.Flags(true, true, true), new CodeGenerator.Flags(true, true), new BytecodeOptimizer.Flags(true)), registry);
        for (ShaderVar shaderVar : shaderVars) {
            ClassNode accessor;
            try {
                accessor = CompiledUniforms.compile(compiler, shaderVar, carrier, updateMethod.instructions);
            }
            catch (Exception e) {
                Share.log.error("Failed to compile custom shader uniform {} with code: {}", new Object[]{shaderVar.name(), shaderVar.expression().replace('\n', ' ').replace('\r', ' ')});
                Share.log.trace("Stacktrace:", (Throwable)e);
                continue;
            }
            if (accessor != null) {
                accessors.put(shaderVar.name(), accessor);
            }
            varRegistry.addWithNames(new UniformFunction(null, carrier.name, shaderVar.name() + "$get", shaderVar.type(), Collections.emptyList(), false), shaderVar.name());
        }
        updateMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        UniformClassLoader loader = new UniformClassLoader(CompiledUniforms.class.getClassLoader());
        Class carrierClass = loader.define(carrier);
        HashMap<String, Class> accessorClasses = new HashMap<String, Class>();
        for (Map.Entry accessor : accessors.entrySet()) {
            accessorClasses.put((String)accessor.getKey(), loader.define((ClassNode)accessor.getValue()));
        }
        try {
            carrierInstance = (InternalCompiledUniform)carrierClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            accessorInstances = new HashMap<String, CompiledUniform>();
            for (Map.Entry accessorClass : accessorClasses.entrySet()) {
                accessorInstances.put((String)accessorClass.getKey(), (CompiledUniform)((Class)accessorClass.getValue()).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return new CompiledUniforms(accessorInstances, carrierInstance);
    }

    private static void addEmptyConstructor(ClassNode cn) {
        MethodNode init = new MethodNode(1, "<init>", "()V", null, null);
        init.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        init.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Object", "<init>", "()V", false));
        init.instructions.add((AbstractInsnNode)new InsnNode(177));
        cn.methods.add(init);
    }

    @Nullable
    private static ClassNode compile(UniformCompiler comp, ShaderVar var, ClassNode carrier, InsnList updateMethod) {
        ShaderVar.Variant variant = var.variant();
        com.ventooth.swansong.uniforms.Type type = var.type();
        String name = var.name();
        String expr = var.expression();
        String fieldDesc = type.descriptor();
        String methodDesc = "()" + fieldDesc;
        int retOpcode = type.returnOpcode();
        String name$state = name + "$state";
        String name$get = name + "$get";
        String name$update = name + "$update";
        MethodNode staticUpdate = new MethodNode(10, name$update, "()V", null, null);
        InsnList insn = staticUpdate.instructions;
        comp.compile(type, expr, insn, true);
        insn.add((AbstractInsnNode)new FieldInsnNode(179, carrier.name, name$state, fieldDesc));
        insn.add((AbstractInsnNode)new InsnNode(177));
        carrier.methods.add(staticUpdate);
        carrier.fields.add(new FieldNode(10, name$state, fieldDesc, null, null));
        MethodNode staticGet = new MethodNode(9, name$get, methodDesc, null, null);
        carrier.methods.add(staticGet);
        insn = staticGet.instructions;
        insn.add((AbstractInsnNode)new FieldInsnNode(178, carrier.name, name$state, fieldDesc));
        insn.add((AbstractInsnNode)new InsnNode(retOpcode));
        updateMethod.add((AbstractInsnNode)new MethodInsnNode(184, carrier.name, name$update, "()V", false));
        if (variant != ShaderVar.Variant.Uniform) {
            return null;
        }
        ClassNode cn = new ClassNode();
        cn.version = 52;
        cn.superName = "java/lang/Object";
        cn.interfaces.add(uniformTypeInternalNameMap.get((Object)type));
        cn.name = "com/ventooth/swansong/shader/uniform/compiled/__COMP_UNI_" + counter.incrementAndGet() + "_" + name;
        cn.access = 1;
        CompiledUniforms.addEmptyConstructor(cn);
        MethodNode dynamicGet = new MethodNode(17, "value", methodDesc, null, null);
        InsnList insn2 = dynamicGet.instructions;
        insn2.add((AbstractInsnNode)new MethodInsnNode(184, carrier.name, name$get, methodDesc, false));
        insn2.add((AbstractInsnNode)new InsnNode(retOpcode));
        cn.methods.add(dynamicGet);
        return cn;
    }

    @Generated
    public CompiledUniforms(Map<String, CompiledUniform> uniforms, InternalCompiledUniform carrier) {
        this.uniforms = uniforms;
        this.carrier = carrier;
    }

    static {
        uniformTypeInternalNameMap.put(com.ventooth.swansong.uniforms.Type.Float, Type.getInternalName(CompiledUniform.Float.class));
        uniformTypeInternalNameMap.put(com.ventooth.swansong.uniforms.Type.Int, Type.getInternalName(CompiledUniform.Int.class));
        uniformTypeInternalNameMap.put(com.ventooth.swansong.uniforms.Type.Bool, Type.getInternalName(CompiledUniform.Bool.class));
        uniformTypeInternalNameMap.put(com.ventooth.swansong.uniforms.Type.Vec2, Type.getInternalName(CompiledUniform.Vec2.class));
        uniformTypeInternalNameMap.put(com.ventooth.swansong.uniforms.Type.Vec3, Type.getInternalName(CompiledUniform.Vec3.class));
        uniformTypeInternalNameMap.put(com.ventooth.swansong.uniforms.Type.Vec4, Type.getInternalName(CompiledUniform.Vec4.class));
    }

    public static interface InternalCompiledUniform {
        public void update();
    }

    private static class UniformClassLoader
    extends ClassLoader {
        private final Map<String, Class<?>> knownClasses = new HashMap();
        private static final Path debugDir = FileUtil.getMinecraftHomePath().resolve("swansong_uniform_compiler");

        UniformClassLoader(ClassLoader parent) {
            super(parent);
            if (DebugConfig.DumpCompiledUniforms) {
                if (Files.exists(debugDir, new LinkOption[0])) {
                    try {
                        FileUtils.deleteDirectory((File)debugDir.toFile());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    Files.createDirectories(debugDir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> cls = this.knownClasses.get(name);
            if (cls == null) {
                throw new ClassNotFoundException(name);
            }
            return cls;
        }

        private Class<?> define(ClassNode cn) {
            String name = cn.name.replace('/', '.');
            ClassWriter writer = new ClassWriter(3);
            cn.accept((ClassVisitor)writer);
            byte[] bytes = writer.toByteArray();
            if (DebugConfig.DumpCompiledUniforms) {
                Path dumpFile = debugDir.resolve(cn.name + ".class");
                try {
                    Files.createDirectories(dumpFile.getParent(), new FileAttribute[0]);
                    Files.write(dumpFile, bytes, new OpenOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Class<?> klass = this.defineClass(name, bytes, 0, bytes.length);
            this.knownClasses.put(name, klass);
            return klass;
        }
    }
}

