/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.tessellator;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.mixin.mixins.client.TessellatorAccessor;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.ShaderEntityData;
import com.ventooth.swansong.tessellator.ShaderVert;
import com.ventooth.swansong.todo.tess.DanglingWiresTess;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class ShaderTess {
    public static final int MIN_BUFFER_SIZE_INTS = 65536;
    public static final int MAX_BUFFER_SIZE_INTS = 0x1000000;
    public static final int TRIANGLE_VERTEX_COUNT = 3;
    public static final int QUAD_VERTEX_COUNT = 4;
    protected final Tessellator tess;
    protected final ShaderEntityData entityData;
    protected final ShaderVert vertA;
    protected final ShaderVert vertB;
    protected final ShaderVert vertC;
    protected final ShaderVert vertD;

    public static int vertexStrideInt() {
        return ShaderEngine.isInitialized() ? 20 : 8;
    }

    public static int vertexStrideByte() {
        return ShaderTess.vertexStrideInt() * 4;
    }

    public ShaderTess(Tessellator tess) {
        this.tess = tess;
        this.entityData = ShaderEntityData.get();
        this.vertA = new ShaderVert();
        this.vertB = new ShaderVert();
        this.vertC = new ShaderVert();
        this.vertD = new ShaderVert();
    }

    public void addVertex(double posX, double posY, double posZ) {
        float fPosX = (float)(posX + this.tess.field_78408_v);
        float fPosY = (float)(posY + this.tess.field_78407_w);
        float fPosZ = (float)(posZ + this.tess.field_78417_x);
        this.addVertex(fPosX, fPosY, fPosZ);
    }

    public int draw() {
        int iStride = ShaderTess.vertexStrideInt();
        int bStride = ShaderTess.vertexStrideByte();
        if (!this.tess.field_78415_z) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.tess.field_78415_z = false;
        if (this.tess.field_78409_u == 7 && this.tess.field_78406_i % 4 != 0) {
            Share.log.warn("Bad vertex count for Quads: {}", new Object[]{this.tess.field_78406_i});
        }
        if (this.tess.field_78409_u == 4 && this.tess.field_78406_i % 3 != 0) {
            Share.log.warn("Bad vertex count for Triangles: {}", new Object[]{this.tess.field_78406_i});
        }
        int voffset = 0;
        int realDrawMode = this.tess.field_78409_u;
        while (voffset < this.tess.field_78406_i) {
            int vcount = Math.min(this.tess.field_78406_i - voffset, TessellatorAccessor.getTessByteBuf().capacity() / bStride);
            if (realDrawMode == 7) {
                vcount = vcount / 4 * 4;
            }
            TessellatorAccessor.getTessFloatBuf().clear();
            TessellatorAccessor.getTessShortBuf().clear();
            TessellatorAccessor.getTessIntBuf().clear();
            TessellatorAccessor.getTessIntBuf().put(this.tess.field_78405_h, voffset * iStride, vcount * iStride);
            TessellatorAccessor.getTessByteBuf().position(0);
            TessellatorAccessor.getTessByteBuf().limit(vcount * bStride);
            voffset += vcount;
            if (this.tess.field_78400_o) {
                TessellatorAccessor.getTessFloatBuf().position(3);
                GL11.glTexCoordPointer((int)2, (int)bStride, (FloatBuffer)TessellatorAccessor.getTessFloatBuf());
                GL11.glEnableClientState((int)32888);
            }
            if (this.tess.field_78414_p) {
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                TessellatorAccessor.getTessShortBuf().position(12);
                GL11.glTexCoordPointer((int)2, (int)bStride, (ShortBuffer)TessellatorAccessor.getTessShortBuf());
                GL11.glEnableClientState((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            }
            if (this.tess.field_78399_n) {
                TessellatorAccessor.getTessByteBuf().position(20);
                GL11.glColorPointer((int)4, (int)5121, (int)bStride, (ByteBuffer)TessellatorAccessor.getTessByteBuf());
                GL11.glEnableClientState((int)32886);
            }
            if (this.tess.field_78413_q) {
                TessellatorAccessor.getTessFloatBuf().position(9);
                GL11.glNormalPointer((int)bStride, (FloatBuffer)TessellatorAccessor.getTessFloatBuf());
                GL11.glEnableClientState((int)32885);
            }
            TessellatorAccessor.getTessFloatBuf().position(0);
            GL11.glVertexPointer((int)3, (int)bStride, (FloatBuffer)TessellatorAccessor.getTessFloatBuf());
            this.preDrawArray();
            GL11.glEnableClientState((int)32884);
            GL11.glDrawArrays((int)realDrawMode, (int)0, (int)vcount);
        }
        GL11.glDisableClientState((int)32884);
        this.postDrawArray();
        if (this.tess.field_78400_o) {
            GL11.glDisableClientState((int)32888);
        }
        if (this.tess.field_78414_p) {
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GL11.glDisableClientState((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
        if (this.tess.field_78399_n) {
            GL11.glDisableClientState((int)32886);
        }
        if (this.tess.field_78413_q) {
            GL11.glDisableClientState((int)32885);
        }
        int n = this.tess.field_147569_p * 4;
        this.tess.func_78379_d();
        return n;
    }

    protected void preDrawArray() {
        int bStride = ShaderTess.vertexStrideByte();
        if (DanglingWiresTess.useEntityAttrib) {
            TessellatorAccessor.getTessShortBuf().position(14);
            GL20.glVertexAttribPointer((int)DanglingWiresTess.entityAttrib, (int)3, (boolean)false, (boolean)false, (int)bStride, (ShortBuffer)TessellatorAccessor.getTessShortBuf());
            GL20.glEnableVertexAttribArray((int)DanglingWiresTess.entityAttrib);
        }
        if (this.tess.field_78400_o) {
            if (DanglingWiresTess.useTangentAttrib) {
                TessellatorAccessor.getTessFloatBuf().position(12);
                GL20.glVertexAttribPointer((int)DanglingWiresTess.tangentAttrib, (int)4, (boolean)false, (int)bStride, (FloatBuffer)TessellatorAccessor.getTessFloatBuf());
                GL20.glEnableVertexAttribArray((int)DanglingWiresTess.tangentAttrib);
            }
            if (DanglingWiresTess.useMidTexCoordAttrib) {
                TessellatorAccessor.getTessFloatBuf().position(16);
                GL20.glVertexAttribPointer((int)DanglingWiresTess.midTexCoordAttrib, (int)2, (boolean)false, (int)bStride, (FloatBuffer)TessellatorAccessor.getTessFloatBuf());
                GL20.glEnableVertexAttribArray((int)DanglingWiresTess.midTexCoordAttrib);
            }
            if (DanglingWiresTess.useMultiTexCoord3Attrib) {
                TessellatorAccessor.getTessFloatBuf().position(16);
                GL13.glClientActiveTexture((int)33987);
                GL11.glTexCoordPointer((int)2, (int)bStride, (FloatBuffer)TessellatorAccessor.getTessFloatBuf());
                GL11.glEnableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
            }
            if (DanglingWiresTess.useEdgeTexCoordAttrib) {
                TessellatorAccessor.getTessFloatBuf().position(18);
                GL20.glVertexAttribPointer((int)DanglingWiresTess.edgeTexCoordAttrib, (int)2, (boolean)false, (int)bStride, (FloatBuffer)TessellatorAccessor.getTessFloatBuf());
                GL20.glEnableVertexAttribArray((int)DanglingWiresTess.edgeTexCoordAttrib);
            }
        }
    }

    protected void postDrawArray() {
        if (DanglingWiresTess.useEntityAttrib) {
            GL20.glDisableVertexAttribArray((int)DanglingWiresTess.entityAttrib);
        }
        if (this.tess.field_78400_o) {
            if (DanglingWiresTess.useTangentAttrib) {
                GL20.glDisableVertexAttribArray((int)DanglingWiresTess.tangentAttrib);
            }
            if (DanglingWiresTess.useMidTexCoordAttrib) {
                GL20.glDisableVertexAttribArray((int)DanglingWiresTess.midTexCoordAttrib);
            }
            if (DanglingWiresTess.useMultiTexCoord3Attrib) {
                GL13.glClientActiveTexture((int)33987);
                GL11.glDisableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
            }
            if (DanglingWiresTess.useEdgeTexCoordAttrib) {
                GL20.glDisableVertexAttribArray((int)DanglingWiresTess.edgeTexCoordAttrib);
            }
        }
    }

    protected void addVertex(float posX, float posY, float posZ) {
        if (this.tess.field_78409_u == 4) {
            switch (this.tess.field_78411_s % 3) {
                case 0: {
                    this.prepareVertex(this.vertA, posX, posY, posZ);
                    break;
                }
                case 1: {
                    this.prepareVertex(this.vertB, posX, posY, posZ);
                    break;
                }
                case 2: {
                    this.prepareVertex(this.vertC, posX, posY, posZ);
                }
                default: {
                    this.addTrianglePrimitive();
                    break;
                }
            }
        } else if (this.tess.field_78409_u == 7) {
            switch (this.tess.field_78411_s % 4) {
                case 0: {
                    this.prepareVertex(this.vertA, posX, posY, posZ);
                    break;
                }
                case 1: {
                    this.prepareVertex(this.vertB, posX, posY, posZ);
                    break;
                }
                case 2: {
                    this.prepareVertex(this.vertC, posX, posY, posZ);
                    break;
                }
                case 3: {
                    this.prepareVertex(this.vertD, posX, posY, posZ);
                }
                default: {
                    this.addQuadPrimitive();
                    break;
                }
            }
        } else {
            this.prepareVertex(this.vertA, posX, posY, posZ);
            this.addVertex(this.vertA);
        }
    }

    protected void prepareBuffer() {
        int bufferSize = Math.min(this.tess.field_78405_h == null ? 0 : this.tess.field_78405_h.length, ((TessellatorAccessor)this.tess).rawBufferSize());
        int expectedSize = Math.max(this.tess.field_147569_p + this.requiredSpaceInts() + 128, 65536);
        if (expectedSize < bufferSize) {
            return;
        }
        this.extendBuffer(bufferSize, expectedSize);
    }

    protected int requiredSpaceInts() {
        int n;
        int iStride = ShaderTess.vertexStrideInt();
        switch (this.tess.field_78409_u) {
            case 4: {
                n = iStride * 3;
                break;
            }
            case 7: {
                n = iStride * 4;
                break;
            }
            default: {
                n = iStride;
            }
        }
        return n;
    }

    protected void extendBuffer(int oldBufferSize, int expectedSize) {
        int newBufferSize1 = oldBufferSize * 2;
        int newBufferSize2 = (int)Math.ceil((double)expectedSize * 1.5);
        int newBufferSize = Math.max(newBufferSize1, newBufferSize2);
        int[] oldRawBuffer = this.tess.field_78405_h;
        int[] newRawBuffer = oldRawBuffer == null ? new int[newBufferSize] : Arrays.copyOf(oldRawBuffer, newBufferSize);
        ((TessellatorAccessor)this.tess).rawBufferSize(newBufferSize);
        this.tess.field_78405_h = newRawBuffer;
    }

    protected void prepareVertex(ShaderVert vertex, float posX, float posY, float posZ) {
        vertex.positionX = posX;
        vertex.positionY = posY;
        vertex.positionZ = posZ;
        vertex.textureU = (float)this.tess.field_78403_j;
        vertex.textureV = (float)this.tess.field_78404_k;
        vertex.colorARGB = this.tess.field_78402_m;
        vertex.lightMapUV = this.tess.field_78401_l;
        vertex.entityData = this.entityData.getEntityData();
        vertex.entityData2 = this.entityData.getEntityData2();
        ++this.tess.field_78411_s;
        ++this.tess.field_78406_i;
    }

    protected void addTrianglePrimitive() {
        this.calculateTriangleNormal();
        this.calculateTangent();
        this.calculateTriangleMidAndEdgeTexUV();
        this.addVertex(this.vertA);
        this.addVertex(this.vertB);
        this.addVertex(this.vertC);
    }

    protected void addQuadPrimitive() {
        this.calculateQuadNormal();
        this.calculateTangent();
        this.calculateQuadMidAndEdgeTexUV();
        this.addVertex(this.vertA);
        this.addVertex(this.vertB);
        this.addVertex(this.vertC);
        this.addVertex(this.vertD);
    }

    protected void calculateTriangleNormal() {
        float length_AC_X = this.vertC.positionX - this.vertA.positionX;
        float length_AC_Y = this.vertC.positionY - this.vertA.positionY;
        float length_AC_Z = this.vertC.positionZ - this.vertA.positionZ;
        float length_AB_X = this.vertA.positionX - this.vertB.positionX;
        float length_AB_Y = this.vertA.positionY - this.vertB.positionY;
        float length_AB_Z = this.vertA.positionZ - this.vertB.positionZ;
        float normalX = length_AC_Y * length_AB_Z - length_AC_Z * length_AB_Y;
        float normalY = length_AC_Z * length_AB_X - length_AC_X * length_AB_Z;
        float normalZ = length_AC_X * length_AB_Y - length_AC_Y * length_AB_X;
        float length = ShaderTess.safeSqrt(normalX * normalX + normalY * normalY + normalZ * normalZ);
        this.setVertNormal(this.vertA, normalX /= length, normalY /= length, normalZ /= length);
        this.setVertNormal(this.vertB, normalX, normalY, normalZ);
        this.setVertNormal(this.vertC, normalX, normalY, normalZ);
        this.tess.field_78413_q = true;
    }

    protected void calculateQuadNormal() {
        float length_AC_X = this.vertC.positionX - this.vertA.positionX;
        float length_AC_Y = this.vertC.positionY - this.vertA.positionY;
        float length_AC_Z = this.vertC.positionZ - this.vertA.positionZ;
        float length_DB_X = this.vertD.positionX - this.vertB.positionX;
        float length_DB_Y = this.vertD.positionY - this.vertB.positionY;
        float length_DB_Z = this.vertD.positionZ - this.vertB.positionZ;
        float normalX = length_AC_Y * length_DB_Z - length_AC_Z * length_DB_Y;
        float normalY = length_AC_Z * length_DB_X - length_AC_X * length_DB_Z;
        float normalZ = length_AC_X * length_DB_Y - length_AC_Y * length_DB_X;
        float length = ShaderTess.safeSqrt(normalX * normalX + normalY * normalY + normalZ * normalZ);
        this.setVertNormal(this.vertA, normalX /= length, normalY /= length, normalZ /= length);
        this.setVertNormal(this.vertB, normalX, normalY, normalZ);
        this.setVertNormal(this.vertC, normalX, normalY, normalZ);
        this.setVertNormal(this.vertD, normalX, normalY, normalZ);
        this.tess.field_78413_q = true;
    }

    protected void setVertNormal(ShaderVert vert, float normalX, float normalY, float normalZ) {
        vert.normalX = normalX;
        vert.normalY = normalY;
        vert.normalZ = normalZ;
    }

    protected void calculateTangent() {
        float length_AB_X = this.vertB.positionX - this.vertA.positionX;
        float length_AB_Y = this.vertB.positionY - this.vertA.positionY;
        float length_AB_Z = this.vertB.positionZ - this.vertA.positionZ;
        float length_AC_X = this.vertC.positionX - this.vertA.positionX;
        float length_AC_Y = this.vertC.positionY - this.vertA.positionY;
        float length_AC_Z = this.vertC.positionZ - this.vertA.positionZ;
        float length_AB_U = this.vertB.textureU - this.vertA.textureU;
        float length_AC_V = this.vertC.textureV - this.vertA.textureV;
        float length_AC_U = this.vertC.textureU - this.vertA.textureU;
        float length_AB_V = this.vertB.textureV - this.vertA.textureV;
        float lengthSq_UV = length_AB_U * length_AC_V - length_AC_U * length_AB_V;
        float deltaFactor = (double)lengthSq_UV == 0.0 ? 1.0f : 1.0f / lengthSq_UV;
        float tangentXUnscaled = deltaFactor * (length_AC_V * length_AB_X - length_AB_V * length_AC_X);
        float tangentYUnscaled = deltaFactor * (length_AC_V * length_AB_Y - length_AB_V * length_AC_Y);
        float tangentZUnscaled = deltaFactor * (length_AC_V * length_AB_Z - length_AB_V * length_AC_Z);
        float tangentLength = ShaderTess.safeSqrt(tangentXUnscaled * tangentXUnscaled + tangentYUnscaled * tangentYUnscaled + tangentZUnscaled * tangentZUnscaled);
        float tangentX = tangentXUnscaled / tangentLength;
        float tangentY = tangentYUnscaled / tangentLength;
        float tangentZ = tangentZUnscaled / tangentLength;
        float biTangentXUnscaled = deltaFactor * (-length_AC_U * length_AB_X + length_AB_U * length_AC_X);
        float biTangentYUnscaled = deltaFactor * (-length_AC_U * length_AB_Y + length_AB_U * length_AC_Y);
        float biTangentZUnscaled = deltaFactor * (-length_AC_U * length_AB_Z + length_AB_U * length_AC_Z);
        float biTangentLength = ShaderTess.safeSqrt(biTangentXUnscaled * biTangentXUnscaled + biTangentYUnscaled * biTangentYUnscaled + biTangentZUnscaled * biTangentZUnscaled);
        float biTangentX = biTangentXUnscaled / biTangentLength;
        float biTangentY = biTangentYUnscaled / biTangentLength;
        float biTangentZ = biTangentZUnscaled / biTangentLength;
        float otherBiTangentX = tangentY * this.vertA.normalZ - tangentZ * this.vertA.normalY;
        float otherBiTangentY = tangentZ * this.vertA.normalX - tangentX * this.vertA.normalZ;
        float otherBiTangentZ = tangentX * this.vertA.normalY - tangentY * this.vertA.normalX;
        float tangentDotProduct = biTangentX * otherBiTangentX + biTangentY * otherBiTangentY + biTangentZ * otherBiTangentZ;
        float tangentW = tangentDotProduct < 0.0f ? -1.0f : 1.0f;
        if (this.tess.field_78409_u == 4) {
            this.setVertTangent(this.vertA, tangentX, tangentY, tangentZ, tangentW);
            this.setVertTangent(this.vertB, tangentX, tangentY, tangentZ, tangentW);
            this.setVertTangent(this.vertC, tangentX, tangentY, tangentZ, tangentW);
        } else if (this.tess.field_78409_u == 7) {
            this.setVertTangent(this.vertA, tangentX, tangentY, tangentZ, tangentW);
            this.setVertTangent(this.vertB, tangentX, tangentY, tangentZ, tangentW);
            this.setVertTangent(this.vertC, tangentX, tangentY, tangentZ, tangentW);
            this.setVertTangent(this.vertD, tangentX, tangentY, tangentZ, tangentW);
        }
    }

    protected void setVertTangent(ShaderVert vert, float tangentX, float tangentY, float tangentZ, float tangentW) {
        vert.tangentX = tangentX;
        vert.tangentY = tangentY;
        vert.tangentZ = tangentZ;
        vert.tangentW = tangentW;
    }

    protected void calculateTriangleMidAndEdgeTexUV() {
        ShaderVert a = this.vertA;
        float au = a.textureU;
        float av = a.textureV;
        ShaderVert b = this.vertB;
        float bu = b.textureU;
        float bv = b.textureV;
        ShaderVert c = this.vertC;
        float cu = c.textureU;
        float cv = c.textureV;
        float minU = ShaderTess.min(au, bu, cu);
        float minV = ShaderTess.min(av, bv, cv);
        float maxU = ShaderTess.max(au, bu, cu);
        float maxV = ShaderTess.max(av, bv, cv);
        float midU = (minU + maxU) / 2.0f;
        float midV = (minV + maxV) / 2.0f;
        this.setVertEdgeAndMidTexture(a, minU, minV, midU, midV);
        this.setVertEdgeAndMidTexture(b, minU, minV, midU, midV);
        this.setVertEdgeAndMidTexture(c, minU, minV, midU, midV);
    }

    protected void calculateQuadMidAndEdgeTexUV() {
        ShaderVert a = this.vertA;
        float au = a.textureU;
        float av = a.textureV;
        ShaderVert b = this.vertB;
        float bu = b.textureU;
        float bv = b.textureV;
        ShaderVert c = this.vertC;
        float cu = c.textureU;
        float cv = c.textureV;
        ShaderVert d = this.vertD;
        float du = d.textureU;
        float dv = d.textureV;
        float minU = ShaderTess.min(au, bu, cu, du);
        float minV = ShaderTess.min(av, bv, cv, dv);
        float maxU = ShaderTess.max(au, bu, cu, du);
        float maxV = ShaderTess.max(av, bv, cv, dv);
        float midU = (minU + maxU) / 2.0f;
        float midV = (minV + maxV) / 2.0f;
        this.setVertEdgeAndMidTexture(a, minU, minV, midU, midV);
        this.setVertEdgeAndMidTexture(b, minU, minV, midU, midV);
        this.setVertEdgeAndMidTexture(c, minU, minV, midU, midV);
        this.setVertEdgeAndMidTexture(d, minU, minV, midU, midV);
    }

    protected void setVertEdgeAndMidTexture(ShaderVert vert, float edgeTextureU, float edgeTextureV, float midTextureU, float midTextureV) {
        this.setVertEdgeTexture(vert, edgeTextureU, edgeTextureV);
        this.setVertMidTexture(vert, midTextureU, midTextureV);
    }

    protected void setVertMidTexture(ShaderVert vert, float midTextureU, float midTextureV) {
        vert.midTextureU = midTextureU;
        vert.midTextureV = midTextureV;
    }

    protected void setVertEdgeTexture(ShaderVert vert, float edgeTextureU, float edgeTextureV) {
        vert.edgeTextureU = edgeTextureU;
        vert.edgeTextureV = edgeTextureV;
    }

    protected void addVertex(ShaderVert vertex) {
        this.prepareBuffer();
        vertex.toIntArray(this.tess.field_147569_p, this.tess.field_78405_h);
        this.tess.field_147569_p += ShaderTess.vertexStrideInt();
    }

    protected static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    protected static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    protected static float min(float a, float b, float c, float d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    protected static float max(float a, float b, float c, float d) {
        return Math.max(Math.max(a, b), Math.max(c, d));
    }

    protected static float safeSqrt(float value) {
        return value != 0.0f ? (float)Math.sqrt(value) : 1.0f;
    }
}

