/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.swansong.uniforms.UniformFunctionRegistry;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;

public class StatefulBuiltins {
    public static final UniformFunctionRegistry REGISTRY = StatefulBuiltins.register();
    private static final BitSet randDB = new BitSet();
    private static double[] randDD = new double[32];
    private static final BitSet randIB = new BitSet();
    private static int[] randID = new int[32];
    private static final BitSet smoothB = new BitSet();
    private static double[] smoothVal = new double[32];
    private static long[] smoothNs = new long[32];
    private static final Random rng = new Random();

    private static UniformFunctionRegistry register() {
        Class<StatefulBuiltins> klass = StatefulBuiltins.class;
        UniformFunctionRegistry.Single reg = new UniformFunctionRegistry.Single();
        reg.statefulIndexed(klass.getDeclaredMethod("random", Integer.TYPE));
        reg.statefulIndexed(klass.getDeclaredMethod("random", Integer.TYPE, Double.TYPE, Double.TYPE));
        reg.statefulIndexed(klass.getDeclaredMethod("randomInt", Integer.TYPE));
        reg.statefulIndexed(klass.getDeclaredMethod("randomInt", Integer.TYPE, Integer.TYPE, Integer.TYPE));
        reg.statefulIndexed(klass.getDeclaredMethod("smooth", Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
        return reg;
    }

    public static void update() {
        StatefulBuiltins.resetRands();
    }

    public static void reset() {
        StatefulBuiltins.resetRands();
        smoothB.clear();
    }

    public static double random(int index) {
        if (randDB.get(index)) {
            return randDD[index];
        }
        randDB.set(index);
        double value = rng.nextDouble();
        if (randDD.length <= index) {
            randDD = Arrays.copyOf(randDD, MathUtil.smallestEncompassingPowerOfTwo((int)(index + 1)));
        }
        StatefulBuiltins.randDD[index] = value;
        return value;
    }

    public static double random(int index, double min, double max) {
        if (randDB.get(index)) {
            return randDD[index];
        }
        randDB.set(index);
        double value = min + (max - min) * rng.nextDouble();
        if (randDD.length <= index) {
            randDD = Arrays.copyOf(randDD, MathUtil.smallestEncompassingPowerOfTwo((int)(index + 1)));
        }
        StatefulBuiltins.randDD[index] = value;
        return value;
    }

    public static int randomInt(int index) {
        if (randIB.get(index)) {
            return randID[index];
        }
        randIB.set(index);
        int value = rng.nextInt();
        if (randID.length <= index) {
            randID = Arrays.copyOf(randID, MathUtil.smallestEncompassingPowerOfTwo((int)(index + 1)));
        }
        StatefulBuiltins.randID[index] = value;
        return value;
    }

    public static int randomInt(int index, int min, int max) {
        if (randIB.get(index)) {
            return randID[index];
        }
        randIB.set(index);
        int value = min + rng.nextInt(max - min);
        if (randID.length <= index) {
            randID = Arrays.copyOf(randID, MathUtil.smallestEncompassingPowerOfTwo((int)(index + 1)));
        }
        StatefulBuiltins.randID[index] = value;
        return value;
    }

    public static double smooth(int index, double value, double fadeUpTime, double fadeDownTime) {
        double valPrev;
        long timePrev;
        long time = System.nanoTime();
        if (smoothB.get(index)) {
            timePrev = smoothNs[index];
            valPrev = smoothVal[index];
        } else {
            smoothB.set(index);
            if (smoothNs.length <= index) {
                smoothNs = Arrays.copyOf(smoothNs, MathUtil.smallestEncompassingPowerOfTwo((int)(index + 1)));
            }
            if (smoothVal.length <= index) {
                smoothVal = Arrays.copyOf(smoothVal, MathUtil.smallestEncompassingPowerOfTwo((int)(index + 1)));
            }
            timePrev = time;
            valPrev = value;
        }
        long timeDeltaNanos = time - timePrev;
        double timeDeltaSec = (double)timeDeltaNanos / 1.0E9;
        double timeFadeSec = value >= valPrev ? fadeUpTime : fadeDownTime;
        double valSmooth = StatefulBuiltins.getSmoothValue(valPrev, value, timeDeltaSec, timeFadeSec);
        StatefulBuiltins.smoothNs[index] = time;
        StatefulBuiltins.smoothVal[index] = valSmooth;
        return valSmooth;
    }

    private static void resetRands() {
        randDB.clear();
        randIB.clear();
    }

    private static double getSmoothValue(double valPrev, double value, double timeDeltaSec, double timeFadeSec) {
        double valSmooth;
        if (timeDeltaSec <= 0.0) {
            return valPrev;
        }
        double valDelta = value - valPrev;
        if (timeFadeSec > 0.0 && timeDeltaSec < timeFadeSec && Math.abs(valDelta) > 1.0E-6) {
            double countUpdates = timeFadeSec / timeDeltaSec;
            double k1 = 4.61;
            double k2 = 0.13;
            double k3 = 10.0;
            double kCorr = k1 - 1.0 / (k2 + countUpdates / k3);
            double kTime = timeDeltaSec / timeFadeSec * kCorr;
            kTime = MathUtil.clamp((double)kTime, (double)0.0, (double)1.0);
            valSmooth = valPrev + valDelta * kTime;
        } else {
            valSmooth = value;
        }
        return valSmooth;
    }
}

