/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms;

import com.ventooth.swansong.uniforms.Type;
import com.ventooth.swansong.uniforms.UniformFunction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UniformFunctionRegistry {
    @Nullable
    protected abstract Iterable<UniformFunction> registeredMethods(String var1);

    public UniformFunction resolve(String name, List<Type> paramTypes) {
        Iterable<UniformFunction> methods = this.registeredMethods(name);
        if (methods == null) {
            return null;
        }
        for (UniformFunction method : methods) {
            if (!method.params().equals(paramTypes)) continue;
            return method;
        }
        block1: for (UniformFunction method : methods) {
            List<Type> methodParams = method.params();
            if (methodParams.size() != paramTypes.size()) continue;
            for (int i = 0; i < methodParams.size(); ++i) {
                Type methodParam = methodParams.get(i);
                Type coerced = Type.tryCoerce(paramTypes.get(i), methodParam);
                if (coerced != methodParam) continue block1;
            }
            return method;
        }
        return null;
    }

    public static class Multi
    extends UniformFunctionRegistry {
        private final List<UniformFunctionRegistry> subRegistries = new ArrayList<UniformFunctionRegistry>();

        @Override
        protected Iterable<UniformFunction> registeredMethods(String name) {
            return new MultiIterable(name, this.subRegistries);
        }

        public void add(UniformFunctionRegistry subRegistry) {
            this.subRegistries.add(subRegistry);
        }

        private static final class MultiIterable
        implements Iterable<UniformFunction> {
            private final String name;
            private final Iterable<UniformFunctionRegistry> subIterables;

            private MultiIterable(String name, Iterable<UniformFunctionRegistry> subIterables) {
                this.name = name;
                this.subIterables = subIterables;
            }

            @Override
            @NotNull
            public Iterator<UniformFunction> iterator() {
                return new MultiIterator(this.name, this.subIterables.iterator());
            }

            public String name() {
                return this.name;
            }

            public Iterable<UniformFunctionRegistry> subIterables() {
                return this.subIterables;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                MultiIterable that = (MultiIterable)obj;
                return Objects.equals(this.name, that.name) && Objects.equals(this.subIterables, that.subIterables);
            }

            public int hashCode() {
                return Objects.hash(this.name, this.subIterables);
            }

            public String toString() {
                return "MultiIterable[name=" + this.name + ", subIterables=" + this.subIterables + ']';
            }

            private static class MultiIterator
            implements Iterator<UniformFunction> {
                private final String name;
                private final Iterator<UniformFunctionRegistry> subIterables;
                private Iterator<UniformFunction> current = null;

                @Override
                public boolean hasNext() {
                    while (true) {
                        if (this.current == null) {
                            Iterable<UniformFunction> methods;
                            if (!this.subIterables.hasNext()) break;
                            UniformFunctionRegistry subReg = this.subIterables.next();
                            if (subReg == null || (methods = subReg.registeredMethods(this.name)) == null) continue;
                            this.current = methods.iterator();
                            continue;
                        }
                        boolean hasNext = this.current.hasNext();
                        if (hasNext) {
                            return true;
                        }
                        this.current = null;
                    }
                    return false;
                }

                @Override
                public UniformFunction next() {
                    return this.current.next();
                }

                @Generated
                public MultiIterator(String name, Iterator<UniformFunctionRegistry> subIterables) {
                    this.name = name;
                    this.subIterables = subIterables;
                }
            }
        }
    }

    public static class Single
    extends UniformFunctionRegistry {
        private final Map<String, List<UniformFunction>> registeredMethods = new HashMap<String, List<UniformFunction>>();

        public void pure(Method method) {
            this.addWithNames(UniformFunction.of(method, true, false), method.getName());
        }

        public void pure(Method method, String ... names) {
            this.addWithNames(UniformFunction.of(method, true, false), names);
        }

        public void impure(Method method) {
            this.addWithNames(UniformFunction.of(method, false, false), method.getName());
        }

        public void impure(Method method, String ... names) {
            this.addWithNames(UniformFunction.of(method, false, false), names);
        }

        public void statefulIndexed(Method method) {
            this.addWithNames(UniformFunction.of(method, false, true), method.getName());
        }

        public void statefulIndexed(Method method, String ... names) {
            this.addWithNames(UniformFunction.of(method, false, true), names);
        }

        public void addWithNames(UniformFunction uni, String ... names) {
            for (String name : names) {
                this.registeredMethods.computeIfAbsent(name, ignored -> new ArrayList()).add(uni);
            }
        }

        @Override
        protected Iterable<UniformFunction> registeredMethods(String name) {
            return this.registeredMethods.getOrDefault(name, Collections.emptyList());
        }
    }
}

