/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms.compiler.backend;

import lombok.Generated;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class BytecodeOptimizer {
    private final Flags flags;

    public void optimize(InsnList insnList) {
        boolean changedInPass;
        do {
            changedInPass = false;
            AbstractInsnNode curr = insnList.getFirst();
            while (curr != null) {
                AbstractInsnNode next = null;
                if (this.flags.optimizeJumps) {
                    next = this.removeUselessJump(curr, insnList);
                    if (next == null) {
                        next = this.mergeChainedJump(curr, insnList);
                    }
                    if (next == null) {
                        next = this.removeDoubleGoto(curr, insnList);
                    }
                }
                if (next != null) {
                    changedInPass = true;
                    curr = next;
                    continue;
                }
                curr = curr.getNext();
            }
        } while (changedInPass);
    }

    private AbstractInsnNode removeDoubleGoto(AbstractInsnNode insn, InsnList insnList) {
        JumpInsnNode jmp2;
        JumpInsnNode jmp1;
        if (!(insn instanceof JumpInsnNode) || (jmp1 = (JumpInsnNode)insn).getOpcode() != 167) {
            return null;
        }
        AbstractInsnNode insn2 = insn.getNext();
        if (!(insn2 instanceof JumpInsnNode) || (jmp2 = (JumpInsnNode)insn2).getOpcode() != 167) {
            return null;
        }
        insnList.remove(insn2);
        return insn;
    }

    private AbstractInsnNode mergeChainedJump(AbstractInsnNode insn, InsnList insnList) {
        JumpInsnNode jmp2;
        JumpInsnNode jmp1;
        if (!(insn instanceof JumpInsnNode) || (jmp1 = (JumpInsnNode)insn).getOpcode() != 167) {
            return null;
        }
        AbstractInsnNode insn2 = insn.getNext();
        if (!(insn2 instanceof LabelNode)) {
            return null;
        }
        LabelNode lbl = (LabelNode)insn2;
        AbstractInsnNode insn3 = insn2.getNext();
        if (!(insn3 instanceof JumpInsnNode) || (jmp2 = (JumpInsnNode)insn3).getOpcode() != 167) {
            return null;
        }
        insnList.remove((AbstractInsnNode)lbl);
        insnList.remove((AbstractInsnNode)jmp2);
        this.replaceJumpTarget(lbl, jmp2.label, insnList);
        return insn;
    }

    private AbstractInsnNode removeUselessJump(AbstractInsnNode insn, InsnList insnList) {
        if (!(insn instanceof JumpInsnNode)) {
            return null;
        }
        JumpInsnNode jmp = (JumpInsnNode)insn;
        AbstractInsnNode next = insn.getNext();
        if (!(next instanceof LabelNode)) {
            return null;
        }
        LabelNode lbl = (LabelNode)next;
        if (jmp.label != lbl) {
            return null;
        }
        insnList.remove((AbstractInsnNode)jmp);
        return next;
    }

    private void replaceJumpTarget(LabelNode from, LabelNode to, InsnList insnList) {
        for (AbstractInsnNode insn : insnList) {
            if (!(insn instanceof JumpInsnNode)) continue;
            JumpInsnNode jump = (JumpInsnNode)insn;
            if (jump.label != from) continue;
            jump.label = to;
        }
    }

    @Generated
    public BytecodeOptimizer(Flags flags) {
        this.flags = flags;
    }

    public static final class Flags {
        public final boolean optimizeJumps;

        @Generated
        public Flags(boolean optimizeJumps) {
            this.optimizeJumps = optimizeJumps;
        }
    }
}

