/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms.compiler.frontend;

import com.ventooth.swansong.uniforms.Type;
import com.ventooth.swansong.uniforms.UniformFunction;
import com.ventooth.swansong.uniforms.VecUtil;
import com.ventooth.swansong.uniforms.compiler.ast.ConstNode;
import com.ventooth.swansong.uniforms.compiler.ast.TypedNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedBoolNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedBranchNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedCastNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedFunctionNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedMathNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedMultiMatchNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedRelNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedUnaryMinusNode;
import com.ventooth.swansong.uniforms.compiler.ast.typed.TypedUnaryNotNode;
import com.ventooth.swansong.uniforms.compiler.transform.Transformation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.joml.Vector2dc;
import org.joml.Vector3dc;
import org.joml.Vector4dc;

public class Optimizer
implements Transformation<TypedNode, TypedNode> {
    private final Flags flags;

    @Override
    public TypedNode transform(TypedNode node) {
        if (node instanceof ConstNode) {
            return node;
        }
        if (node instanceof TypedBoolNode) {
            TypedBoolNode bool = (TypedBoolNode)node;
            return this.optimizeBool(this.transform(bool.elems), bool.op);
        }
        if (node instanceof TypedBranchNode) {
            TypedBranchNode branch = (TypedBranchNode)node;
            return this.optimizeBranch(this.transform(branch.cond), this.transform(branch.ifTrue), this.transform(branch.ifFalse));
        }
        if (node instanceof TypedCastNode) {
            TypedCastNode cast = (TypedCastNode)node;
            return this.optimizeCast(cast.outputType(), this.transform(cast.input));
        }
        if (node instanceof TypedFunctionNode) {
            TypedFunctionNode fn = (TypedFunctionNode)node;
            return this.optimizeFn(fn.function, this.transform(fn.params));
        }
        if (node instanceof TypedMathNode) {
            TypedMathNode math = (TypedMathNode)node;
            return this.optimizeMath(this.transform(math.left), this.transform(math.right), math.op);
        }
        if (node instanceof TypedMultiMatchNode) {
            TypedMultiMatchNode multiMatch = (TypedMultiMatchNode)node;
            return this.optimizeMultiMatch(this.transform(multiMatch.elems));
        }
        if (node instanceof TypedRelNode) {
            TypedRelNode rel = (TypedRelNode)node;
            return this.optimizeRel(this.transform(rel.left), this.transform(rel.right), rel.op);
        }
        if (node instanceof TypedUnaryMinusNode) {
            TypedUnaryMinusNode minus = (TypedUnaryMinusNode)node;
            return this.optimizeUnaryMinus(this.transform(minus.param));
        }
        if (node instanceof TypedUnaryNotNode) {
            TypedUnaryNotNode not = (TypedUnaryNotNode)node;
            return this.optimizeUnaryNot(this.transform(not.param));
        }
        throw new UnsupportedOperationException(node.getClass().getName());
    }

    private TypedNode optimizeUnaryNot(TypedNode input) {
        TypedNode cst;
        if (input instanceof TypedUnaryNotNode) {
            TypedUnaryNotNode not = (TypedUnaryNotNode)input;
            return this.optimizeCast(Type.Bool, not.param);
        }
        if (this.flags.constantFolding && (cst = this.constantFoldUnaryNot(input)) != null) {
            return cst;
        }
        return new TypedUnaryNotNode(input);
    }

    private TypedNode optimizeUnaryMinus(TypedNode input) {
        TypedNode cst;
        if (input instanceof TypedUnaryMinusNode) {
            TypedUnaryMinusNode minus = (TypedUnaryMinusNode)input;
            return minus.param;
        }
        if (this.flags.constantFolding && (cst = this.constantFoldUnaryMinus(input)) != null) {
            return cst;
        }
        return new TypedUnaryMinusNode(input);
    }

    private TypedNode optimizeCast(Type output, TypedNode argument) {
        TypedNode cst;
        if (argument instanceof TypedCastNode) {
            TypedCastNode argCast = (TypedCastNode)argument;
            return this.optimizeCast(output, argCast.input);
        }
        if (argument.outputType() == output) {
            return argument;
        }
        if (this.flags.constantFolding && (cst = this.constantFoldCast(output, argument)) != null) {
            return cst;
        }
        return new TypedCastNode(output, argument);
    }

    private TypedNode optimizeMath(TypedNode left, TypedNode right, TypedMathNode.Op op) {
        TypedNode cst;
        if (this.flags.constantFolding && (cst = this.constantFoldMath(left, right, op)) != null) {
            return cst;
        }
        return new TypedMathNode(left, right, op);
    }

    private TypedNode optimizeBool(List<TypedNode> nodes, TypedBoolNode.Op op) {
        TypedNode cst;
        ArrayList<TypedNode> newNodes = new ArrayList<TypedNode>(nodes.size());
        for (TypedNode node : nodes) {
            if (node instanceof TypedBoolNode) {
                TypedBoolNode bool = (TypedBoolNode)node;
                if (bool.op == op) {
                    newNodes.addAll(bool.elems);
                    continue;
                }
            }
            newNodes.add(node);
        }
        nodes = Collections.unmodifiableList(newNodes);
        if (this.flags.constantFolding && (cst = this.constantFoldBool(nodes, op)) != null) {
            return cst;
        }
        if (this.flags.shortCircuitBool) {
            return this.shortCircuitBool(nodes, op);
        }
        return new TypedBoolNode(nodes, op);
    }

    private TypedNode optimizeRel(TypedNode left, TypedNode right, TypedRelNode.Op op) {
        ConstNode.Bool cst;
        if (this.flags.constantFolding && (cst = this.constantFoldRel(left, right, op)) != null) {
            return cst;
        }
        return new TypedRelNode(left, right, op);
    }

    private TypedNode optimizeBranch(TypedNode cond, TypedNode ifTrue, TypedNode ifFalse) {
        TypedNode cst;
        if (this.flags.constantFolding && (cst = this.constantFoldBranch(cond, ifTrue, ifFalse)) != null) {
            return cst;
        }
        if (cond instanceof TypedUnaryNotNode) {
            TypedUnaryNotNode not = (TypedUnaryNotNode)cond;
            return new TypedBranchNode(not.param, ifFalse, ifTrue);
        }
        return new TypedBranchNode(cond, ifTrue, ifFalse);
    }

    private TypedNode optimizeMultiMatch(List<TypedNode> elems) {
        TypedNode cst;
        if (elems.size() == 2) {
            return this.optimizeRel(elems.get(0), elems.get(1), TypedRelNode.Op.Eq);
        }
        if (this.flags.constantFolding && (cst = this.constantFoldMultiMatch(elems)) != null) {
            return cst;
        }
        return new TypedMultiMatchNode(elems);
    }

    private TypedNode optimizeFn(UniformFunction fn, List<TypedNode> params) {
        TypedNode cst;
        int size = params.size();
        if (this.flags.constantFolding && (cst = this.constantFoldFn(fn, params)) != null) {
            return cst;
        }
        return new TypedFunctionNode(fn, params);
    }

    private TypedNode constantFoldUnaryNot(TypedNode argument) {
        boolean bl;
        if (!(argument instanceof ConstNode)) {
            return null;
        }
        switch (argument.outputType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Bool: {
                if (!((ConstNode.Bool)argument).value()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case Int: {
                if (((ConstNode.Int)argument).value == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case Float: {
                if (((ConstNode.Float)argument).value == 0.0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case Vec2: {
                bl = ((ConstNode.Vec2)argument).value().equals(0.0, 0.0);
                break;
            }
            case Vec3: {
                bl = ((ConstNode.Vec3)argument).value().equals(0.0, 0.0, 0.0);
                break;
            }
            case Vec4: {
                bl = ((ConstNode.Vec4)argument).value().equals(0.0, 0.0, 0.0, 0.0);
            }
        }
        return ConstNode.Bool.of(bl);
    }

    private TypedNode constantFoldUnaryMinus(TypedNode argument) {
        ConstNode constNode;
        if (!(argument instanceof ConstNode)) {
            return null;
        }
        switch (argument.outputType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Bool: {
                if (((ConstNode.Bool)argument).value()) {
                    constNode = ConstNode.Bool.False;
                    break;
                }
                constNode = ConstNode.Int.of(-1);
                break;
            }
            case Int: {
                constNode = ConstNode.Int.of(-((ConstNode.Int)argument).value);
                break;
            }
            case Float: {
                constNode = new ConstNode.Float(-((ConstNode.Float)argument).value);
                break;
            }
            case Vec2: {
                constNode = new ConstNode.Vec2(VecUtil.neg(((ConstNode.Vec2)argument).value()));
                break;
            }
            case Vec3: {
                constNode = new ConstNode.Vec3(VecUtil.neg(((ConstNode.Vec3)argument).value()));
                break;
            }
            case Vec4: {
                constNode = new ConstNode.Vec4(VecUtil.neg(((ConstNode.Vec4)argument).value()));
            }
        }
        return constNode;
    }

    private TypedNode constantFoldCast(Type output, TypedNode argument) {
        ConstNode constNode;
        if (!(argument instanceof ConstNode)) {
            return null;
        }
        block0 : switch (argument.outputType()) {
            case Int: {
                int intVal = ((ConstNode.Int)argument).value;
                switch (output) {
                    case Float: {
                        constNode = new ConstNode.Float(intVal);
                        break block0;
                    }
                    case Vec2: {
                        constNode = new ConstNode.Vec2(intVal, intVal);
                        break block0;
                    }
                    case Vec3: {
                        constNode = new ConstNode.Vec3(intVal, intVal, intVal);
                        break block0;
                    }
                    case Vec4: {
                        constNode = new ConstNode.Vec4(intVal, intVal, intVal, intVal);
                        break block0;
                    }
                }
                constNode = null;
                break;
            }
            case Float: {
                double floatVal = ((ConstNode.Float)argument).value;
                switch (output) {
                    case Int: {
                        constNode = ConstNode.Int.of((int)floatVal);
                        break block0;
                    }
                    case Vec2: {
                        constNode = new ConstNode.Vec2(floatVal, floatVal);
                        break block0;
                    }
                    case Vec3: {
                        constNode = new ConstNode.Vec3(floatVal, floatVal, floatVal);
                        break block0;
                    }
                    case Vec4: {
                        constNode = new ConstNode.Vec4(floatVal, floatVal, floatVal, floatVal);
                        break block0;
                    }
                }
                constNode = null;
                break;
            }
            case Bool: {
                boolean intVal = ((ConstNode.Bool)argument).value();
                switch (output) {
                    case Float: {
                        constNode = new ConstNode.Float((double)intVal);
                        break block0;
                    }
                    case Vec2: {
                        constNode = new ConstNode.Vec2((double)intVal, (double)intVal);
                        break block0;
                    }
                    case Vec3: {
                        constNode = new ConstNode.Vec3((double)intVal, (double)intVal, (double)intVal);
                        break block0;
                    }
                    case Vec4: {
                        constNode = new ConstNode.Vec4((double)intVal, (double)intVal, (double)intVal, (double)intVal);
                        break block0;
                    }
                }
                constNode = null;
                break;
            }
            default: {
                constNode = null;
            }
        }
        return constNode;
    }

    private TypedNode constantFoldMath(TypedNode left, TypedNode right, TypedMathNode.Op op) {
        ConstNode constNode;
        if (!(left instanceof ConstNode) || !(right instanceof ConstNode)) {
            return null;
        }
        block0 : switch (left.outputType()) {
            case Int: {
                int aVal = ((ConstNode.Int)left).value;
                int bVal = ((ConstNode.Int)right).value;
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Add: {
                        constNode = ConstNode.Int.of(aVal + bVal);
                        break block0;
                    }
                    case Sub: {
                        constNode = ConstNode.Int.of(aVal - bVal);
                        break block0;
                    }
                    case Mul: {
                        constNode = ConstNode.Int.of(aVal * bVal);
                        break block0;
                    }
                    case Div: {
                        constNode = ConstNode.Int.of(aVal / bVal);
                        break block0;
                    }
                    case Rem: 
                }
                constNode = ConstNode.Int.of(aVal % bVal);
                break;
            }
            case Float: {
                double aVal = ((ConstNode.Float)left).value;
                double bVal = ((ConstNode.Float)right).value;
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Add: {
                        constNode = new ConstNode.Float(aVal + bVal);
                        break block0;
                    }
                    case Sub: {
                        constNode = new ConstNode.Float(aVal - bVal);
                        break block0;
                    }
                    case Mul: {
                        constNode = new ConstNode.Float(aVal * bVal);
                        break block0;
                    }
                    case Div: {
                        constNode = new ConstNode.Float(aVal / bVal);
                        break block0;
                    }
                    case Rem: 
                }
                constNode = new ConstNode.Float(aVal % bVal);
                break;
            }
            case Vec2: {
                Vector2dc vector2dc;
                Vector2dc vLeft = ((ConstNode.Vec2)left).value();
                Vector2dc vRight = ((ConstNode.Vec2)right).value();
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Add: {
                        vector2dc = VecUtil.add(vLeft, vRight);
                        break;
                    }
                    case Sub: {
                        vector2dc = VecUtil.sub(vLeft, vRight);
                        break;
                    }
                    case Mul: {
                        vector2dc = VecUtil.mul(vLeft, vRight);
                        break;
                    }
                    case Div: {
                        vector2dc = VecUtil.div(vLeft, vRight);
                        break;
                    }
                    case Rem: {
                        vector2dc = VecUtil.rem(vLeft, vRight);
                    }
                }
                constNode = new ConstNode.Vec2(vector2dc);
                break;
            }
            case Vec3: {
                Vector3dc vector3dc;
                Vector3dc vLeft = ((ConstNode.Vec3)left).value();
                Vector3dc vRight = ((ConstNode.Vec3)right).value();
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Add: {
                        vector3dc = VecUtil.add(vLeft, vRight);
                        break;
                    }
                    case Sub: {
                        vector3dc = VecUtil.sub(vLeft, vRight);
                        break;
                    }
                    case Mul: {
                        vector3dc = VecUtil.mul(vLeft, vRight);
                        break;
                    }
                    case Div: {
                        vector3dc = VecUtil.div(vLeft, vRight);
                        break;
                    }
                    case Rem: {
                        vector3dc = VecUtil.rem(vLeft, vRight);
                    }
                }
                constNode = new ConstNode.Vec3(vector3dc);
                break;
            }
            case Vec4: {
                Vector4dc vector4dc;
                Vector4dc vLeft = ((ConstNode.Vec4)left).value();
                Vector4dc vRight = ((ConstNode.Vec4)right).value();
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Add: {
                        vector4dc = VecUtil.add(vLeft, vRight);
                        break;
                    }
                    case Sub: {
                        vector4dc = VecUtil.sub(vLeft, vRight);
                        break;
                    }
                    case Mul: {
                        vector4dc = VecUtil.mul(vLeft, vRight);
                        break;
                    }
                    case Div: {
                        vector4dc = VecUtil.div(vLeft, vRight);
                        break;
                    }
                    case Rem: {
                        vector4dc = VecUtil.rem(vLeft, vRight);
                    }
                }
                constNode = new ConstNode.Vec4(vector4dc);
                break;
            }
            default: {
                constNode = null;
            }
        }
        return constNode;
    }

    private TypedNode constantFoldBool(List<TypedNode> nodes, TypedBoolNode.Op op) {
        boolean bl;
        for (TypedNode node : nodes) {
            if (!(node instanceof ConstNode.Bool)) {
                return null;
            }
            ConstNode.Bool boolNode = (ConstNode.Bool)node;
            boolean nodeVal = boolNode.value();
            switch (op) {
                case And: {
                    if (nodeVal) break;
                    return ConstNode.Bool.of(false);
                }
                case Or: {
                    if (!nodeVal) break;
                    return ConstNode.Bool.of(true);
                }
            }
        }
        switch (op) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case And: {
                bl = true;
                break;
            }
            case Or: {
                bl = false;
            }
        }
        return ConstNode.Bool.of(bl);
    }

    private ConstNode.Bool constantFoldRel(TypedNode left, TypedNode right, TypedRelNode.Op op) {
        ConstNode.Bool bool;
        if (!(left instanceof ConstNode) || !(right instanceof ConstNode)) {
            return null;
        }
        switch (left.outputType()) {
            case Int: {
                boolean bl;
                int aVal = ((ConstNode.Int)left).value;
                int bVal = ((ConstNode.Int)right).value;
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Eq: {
                        if (aVal == bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Ne: {
                        if (aVal != bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Ge: {
                        if (aVal >= bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Gt: {
                        if (aVal > bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Le: {
                        if (aVal <= bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Lt: {
                        bl = aVal < bVal;
                    }
                }
                bool = ConstNode.Bool.of(bl);
                break;
            }
            case Float: {
                boolean bl;
                double aVal = ((ConstNode.Float)left).value;
                double bVal = ((ConstNode.Float)right).value;
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Eq: {
                        if (aVal == bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Ne: {
                        if (aVal != bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Ge: {
                        if (aVal >= bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Gt: {
                        if (aVal > bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Le: {
                        if (aVal <= bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Lt: {
                        bl = aVal < bVal;
                    }
                }
                bool = ConstNode.Bool.of(bl);
                break;
            }
            case Bool: {
                boolean bl;
                boolean aVal = ((ConstNode.Bool)left).value();
                boolean bVal = ((ConstNode.Bool)right).value();
                switch (op) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Eq: {
                        if (aVal == bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Ne: {
                        if (aVal != bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Ge: {
                        if (aVal || !bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Gt: {
                        if (aVal && !bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Le: {
                        if (!aVal || bVal) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case Lt: {
                        bl = !aVal && bVal;
                    }
                }
                bool = ConstNode.Bool.of(bl);
                break;
            }
            default: {
                bool = null;
            }
        }
        return bool;
    }

    private TypedNode constantFoldBranch(TypedNode cond, TypedNode ifTrue, TypedNode ifFalse) {
        if (!(cond instanceof ConstNode.Bool)) {
            return null;
        }
        ConstNode.Bool boolCond = (ConstNode.Bool)cond;
        if (boolCond.value()) {
            return ifTrue;
        }
        return ifFalse;
    }

    private TypedNode constantFoldMultiMatch(List<TypedNode> elems) {
        TypedNode value = elems.get(0);
        if (!(value instanceof ConstNode)) {
            return null;
        }
        ConstNode cstVal = (ConstNode)value;
        int successfulFolds = 0;
        int size = elems.size();
        for (int i = 1; i < size; ++i) {
            ConstNode cstElem;
            ConstNode.Bool folded;
            TypedNode elem = elems.get(i);
            if (!(elem instanceof ConstNode) || (folded = this.constantFoldRel(cstVal, cstElem = (ConstNode)elem, TypedRelNode.Op.Eq)) == null) continue;
            if (folded.value()) {
                return folded;
            }
            ++successfulFolds;
        }
        if (successfulFolds == elems.size() - 1) {
            return ConstNode.Bool.False;
        }
        return null;
    }

    private TypedNode constantFoldFn(UniformFunction method, List<TypedNode> params) {
        ConstNode constNode;
        Object result;
        Method cf = method.constantFoldMethod();
        if (cf == null) {
            return null;
        }
        int size = params.size();
        Object[] args = new Object[size];
        for (int i = 0; i < size; ++i) {
            Vector2dc arg;
            TypedNode param = params.get(i);
            if (!(param instanceof ConstNode)) {
                return null;
            }
            switch (param.outputType()) {
                case Bool: {
                    Object object = ((ConstNode.Bool)param).value();
                    break;
                }
                case Int: {
                    Object object = ((ConstNode.Int)param).value;
                    break;
                }
                case Float: {
                    Object object = ((ConstNode.Float)param).value;
                    break;
                }
                case Vec2: {
                    Object object = ((ConstNode.Vec2)param).value();
                    break;
                }
                case Vec3: {
                    Object object = ((ConstNode.Vec3)param).value();
                    break;
                }
                case Vec4: {
                    Object object = ((ConstNode.Vec4)param).value();
                    break;
                }
                default: {
                    Object object = arg = null;
                }
            }
            if (arg == null) {
                return null;
            }
            args[i] = arg;
        }
        try {
            result = cf.invoke(null, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        switch (method.returns()) {
            case Int: {
                constNode = ConstNode.Int.of((Integer)result);
                break;
            }
            case Float: {
                constNode = new ConstNode.Float((Double)result);
                break;
            }
            case Bool: {
                constNode = ConstNode.Bool.of((Boolean)result);
                break;
            }
            case Vec2: {
                constNode = new ConstNode.Vec2((Vector2dc)result);
                break;
            }
            case Vec3: {
                constNode = new ConstNode.Vec3((Vector3dc)result);
                break;
            }
            case Vec4: {
                constNode = new ConstNode.Vec4((Vector4dc)result);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return constNode;
    }

    private TypedNode shortCircuitBool(List<TypedNode> nodes, TypedBoolNode.Op op) {
        ArrayList<TypedNode> remaining = new ArrayList<TypedNode>(nodes.size());
        for (TypedNode node : nodes) {
            if (!(node instanceof ConstNode.Bool)) {
                remaining.add(node);
                continue;
            }
            ConstNode.Bool nodeConst = (ConstNode.Bool)node;
            boolean nodeVal = nodeConst.value();
            if ((op != TypedBoolNode.Op.Or || !nodeVal) && (op != TypedBoolNode.Op.And || nodeVal)) continue;
            if (!remaining.isEmpty() && this.flags.keepSideEffects) break;
            return ConstNode.Bool.of(nodeVal);
        }
        if (remaining.isEmpty()) {
            boolean bl;
            switch (op) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case And: {
                    bl = true;
                    break;
                }
                case Or: {
                    bl = false;
                }
            }
            return ConstNode.Bool.of(bl);
        }
        if (remaining.size() == 1) {
            return (TypedNode)remaining.get(0);
        }
        return new TypedBoolNode(Collections.unmodifiableList(remaining), op);
    }

    @Generated
    public Optimizer(Flags flags) {
        this.flags = flags;
    }

    public static final class Flags {
        public final boolean constantFolding;
        public final boolean shortCircuitBool;
        public final boolean keepSideEffects;

        @Generated
        public Flags(boolean constantFolding, boolean shortCircuitBool, boolean keepSideEffects) {
            this.constantFolding = constantFolding;
            this.shortCircuitBool = shortCircuitBool;
            this.keepSideEffects = keepSideEffects;
        }
    }
}

