/*
 * Decompiled with CFR 0.152.
 */
package band.kessokuteatime.bounced;

import band.kessokuteatime.splasher.Splasher;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.AccessibilityOnboardingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="bounced", dist={Dist.CLIENT})
public class Bounced {
    public static final String NAME = "Bounced!";
    public static final String ID = "bounced";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bounced");
    private static double primaryPos;
    private static double secondaryPos;
    private static long startTime;
    private static long initializationTime;
    private static long thresholdOffset;
    private static final long primaryAnimationTime = 863L;
    private static final long secondaryAnimationTime = 936L;
    private static final AtomicBoolean shouldAnimate;
    private static final AtomicBoolean shouldJump;

    public Bounced() {
        boolean isSplasherLoaded = ModList.get().isLoaded("splasher");
        NeoForge.EVENT_BUS.addListener(ScreenEvent.Init.Post.class, screenInitEvent -> {
            Screen screen = screenInitEvent.getScreen();
            if (screen instanceof TitleScreen || screen instanceof AccessibilityOnboardingScreen) {
                NeoForge.EVENT_BUS.addListener(ScreenEvent.MouseButtonPressed.Post.class, screenMousePressedEvent -> {
                    double mouseX = screenMousePressedEvent.getMouseX();
                    double mouseY = screenMousePressedEvent.getMouseY();
                    double scaledWidth = screen.width;
                    double centerX = scaledWidth / 2.0;
                    double y = 30.0 + Bounced.primaryPos();
                    double width = 310.0;
                    double height = 44.0;
                    if (!Bounced.isIntro() && mouseX >= centerX - width / 2.0 && mouseX <= centerX + width / 2.0 && mouseY >= y && mouseY <= y + height && (!isSplasherLoaded || !Splasher.isMouseHovering((double)scaledWidth, (double)mouseX, (double)mouseY))) {
                        Bounced.push();
                    }
                });
            }
        });
    }

    public static double offset(boolean isIntro) {
        return (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (isIntro ? 4.1 : 7.0);
    }

    public static void update() {
        double offset = Bounced.offset(Bounced.isIntro());
        if (Bounced.isIntro()) {
            primaryPos = (shouldAnimate.get() ? 0.0 : Bounced.easeOutBounce(863.0) * offset) - offset;
            secondaryPos = (shouldAnimate.get() ? 0.0 : Bounced.easeOutBounce(936.0) * offset) - offset;
        } else if (shouldAnimate.get()) {
            primaryPos = 0.0;
            secondaryPos = 0.0;
        } else if (shouldJump.get() && Math.max(Math.abs(-offset - Bounced.primaryPos()), Math.abs(-offset - Bounced.secondaryPos())) > 0.5) {
            primaryPos += (-offset - Bounced.primaryPos()) * 0.26;
            secondaryPos += (-offset - Bounced.secondaryPos()) * 0.23;
            startTime = System.currentTimeMillis();
        } else {
            shouldJump.set(false);
            primaryPos = Bounced.easeOutBounce(863.0) * offset - offset;
            secondaryPos = Bounced.easeOutBounce(936.0) * offset - offset;
        }
    }

    public static double primaryPos() {
        return primaryPos;
    }

    public static double secondaryPos() {
        return secondaryPos;
    }

    public static long totalAnimationTime() {
        return Math.max(863L, 936L);
    }

    public static boolean isIntro() {
        return System.currentTimeMillis() - (initializationTime + thresholdOffset) <= Bounced.totalAnimationTime();
    }

    public static void init() {
        Bounced.init(false);
    }

    public static void init(boolean force) {
        if (force || !Bounced.isIntro()) {
            initializationTime = System.currentTimeMillis();
            thresholdOffset = -1L;
            shouldJump.set(false);
        }
    }

    public static void push() {
        shouldAnimate.set(true);
        shouldJump.set(true);
    }

    public static void resetWhen(boolean condition) {
        if (condition && shouldAnimate.getAndSet(false)) {
            startTime = System.currentTimeMillis();
            if (thresholdOffset == -1L) {
                thresholdOffset = System.currentTimeMillis() - initializationTime;
            }
        }
    }

    public static double easeOutBounce(double animationTime) {
        double progress = Math.min((double)(System.currentTimeMillis() - startTime) / animationTime, 1.0);
        if (progress < 0.36363636363636365) {
            return 7.5625 * progress * progress;
        }
        if (progress < 0.7272727272727273) {
            return 7.5625 * (progress -= 0.5454545454545454) * progress + 0.75;
        }
        if (progress < 0.9090909090909091) {
            return 7.5625 * (progress -= 0.8181818181818182) * progress + 0.9375;
        }
        return 7.5625 * (progress -= 0.9545454545454546) * progress + 0.984375;
    }

    static {
        startTime = -1L;
        initializationTime = -1L;
        shouldAnimate = new AtomicBoolean(true);
        shouldJump = new AtomicBoolean(false);
    }
}

