/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.fivehead.recipe;

import com.google.common.collect.Lists;
import com.mrbysco.fivehead.recipe.SmartRecipes;
import com.mrbysco.fivehead.registry.SmartRegistry;
import com.mrbysco.fivehead.util.ScaleUtil;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BigBrainRecipe
extends CustomRecipe {
    public BigBrainRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, @NotNull Level level) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack = craftingInput.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack1 = (ItemStack)list.getFirst();
            if (itemstack.getItem() == stack1.getItem() && ScaleUtil.isSkullBlock(itemstack)) continue;
            return false;
        }
        return list.size() == 2;
    }

    @NotNull
    public ItemStack assemble(CraftingInput craftingInput, @NotNull HolderLookup.Provider provider) {
        ItemStack stack2;
        ItemStack stack1;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack = craftingInput.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack12 = (ItemStack)list.getFirst();
            if (itemstack.getItem() == stack12.getItem() || ScaleUtil.isSkullBlock(itemstack)) continue;
            return ItemStack.EMPTY;
        }
        if (list.size() == 2 && ItemStack.isSameItem((ItemStack)(stack1 = (ItemStack)list.get(0)), (ItemStack)(stack2 = (ItemStack)list.get(1)))) {
            float size1 = ((Float)stack1.getOrDefault((DataComponentType)SmartRegistry.SIZE_TYPE.get(), (Object)Float.valueOf(0.03125f))).floatValue();
            float size2 = ((Float)stack2.getOrDefault((DataComponentType)SmartRegistry.SIZE_TYPE.get(), (Object)Float.valueOf(0.03125f))).floatValue();
            float newSize = size1 + size2;
            ItemStack stackCopy = stack1.copy();
            stackCopy.setCount(1);
            stackCopy.set((DataComponentType)SmartRegistry.SIZE_TYPE.get(), (Object)Float.valueOf(newSize));
            return stackCopy;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<BigBrainRecipe> getSerializer() {
        return SmartRecipes.BIG_BRAIN_SERIALIZER.get();
    }
}

