/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EndSkyGlowRenderer {
    private static VertexBuffer starBuffer = null;
    private static final int STARS_PER_REGION = 60;
    private static final int REGION_SIZE = 128;
    private static final double STAR_SIZE = 0.05;

    @SubscribeEvent
    public static void onRenderWorldStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null || !level.m_46472_().equals((Object)Level.f_46430_)) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        EndSkyGlowRenderer.renderEndGradient(poseStack);
        EndSkyGlowRenderer.renderEndInfiniteStars(event.getPoseStack(), level, event.getCamera());
        EndSkyGlowRenderer.renderEndStars(poseStack, level);
    }

    private static void renderEndGradient(PoseStack poseStack) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85837_(0.0, 0.0, 0.0);
        RenderSystem.depthMask((boolean)false);
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float r = 0.14117648f;
        float g = 0.047058824f;
        float b = 0.14509805f;
        float alphaTop = 0.0f;
        float alphaBottom = 1.0f;
        float viewDistance = (float)Minecraft.m_91087_().f_91066_.m_193772_() * 16.0f;
        float radius = Math.min(400.0f, viewDistance * 0.9f);
        float topY = 50.0f;
        float midY = 0.0f;
        float bottomY = -500.0f;
        int segments = 64;
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, 0.0f, topY, 0.0f).m_85950_(r, g, b, alphaTop).m_5752_();
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)i * ((float)Math.PI * 2) / (float)segments;
            float x = Mth.m_14031_((float)angle) * radius;
            float z = Mth.m_14089_((float)angle) * radius;
            buffer.m_252986_(matrix, x, midY, z).m_85950_(r, g, b, alphaBottom).m_5752_();
        }
        tesselator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float half = radius;
        buffer.m_252986_(matrix, -half, midY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
        buffer.m_252986_(matrix, -half, midY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
        buffer.m_252986_(matrix, half, midY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
        buffer.m_252986_(matrix, half, midY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
        float[] ys = new float[]{midY, bottomY};
        for (float y = ys[0]; y > bottomY; y -= 100.0f) {
            float nextY = Math.max(y - 100.0f, bottomY);
            buffer.m_252986_(matrix, -half, nextY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, nextY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, y, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, -half, y, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, -half, nextY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, nextY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, y, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, -half, y, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, nextY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, nextY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, y, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, half, y, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, -half, nextY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, -half, nextY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, -half, y, half).m_85950_(r, g, b, alphaBottom).m_5752_();
            buffer.m_252986_(matrix, -half, y, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
        }
        buffer.m_252986_(matrix, -half, bottomY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
        buffer.m_252986_(matrix, -half, bottomY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
        buffer.m_252986_(matrix, half, bottomY, half).m_85950_(r, g, b, alphaBottom).m_5752_();
        buffer.m_252986_(matrix, half, bottomY, -half).m_85950_(r, g, b, alphaBottom).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    private static void renderEndStars(PoseStack poseStack, ClientLevel level) {
        if (starBuffer == null) {
            EndSkyGlowRenderer.generateStars();
        }
        float celestialAngle = level.m_46942_(0.0f) * 360.0f;
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(celestialAngle / 4.0f));
        Matrix4f model = poseStack.m_85850_().m_252922_();
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        starBuffer.m_85921_();
        starBuffer.m_253207_(model, projection, GameRenderer.m_172808_());
        VertexBuffer.m_85931_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void generateStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        RandomSource random = RandomSource.m_216335_((long)10842L);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double dz;
            double dy;
            double dx = random.m_188501_() * 2.0f - 1.0f;
            double lenSq = dx * dx + (dy = (double)(random.m_188501_() * 2.0f - 1.0f)) * dy + (dz = (double)(random.m_188501_() * 2.0f - 1.0f)) * dz;
            if (!(lenSq < 1.0) || !(lenSq > 0.01)) continue;
            lenSq = 1.0 / Math.sqrt(lenSq);
            double x = (dx *= lenSq) * 100.0;
            double y = (dy *= lenSq) * 100.0;
            double z = (dz *= lenSq) * 100.0;
            double size = 0.15 + random.m_188500_() * 0.1;
            double yaw = Math.atan2(dx, dz);
            double sinYaw = Math.sin(yaw);
            double cosYaw = Math.cos(yaw);
            double pitch = Math.atan2(Math.sqrt(dx * dx + dz * dz), dy);
            double sinPitch = Math.sin(pitch);
            double cosPitch = Math.cos(pitch);
            double roll = random.m_188500_() * Math.PI * 2.0;
            double sinRoll = Math.sin(roll);
            double cosRoll = Math.cos(roll);
            for (int j = 0; j < 4; ++j) {
                double xOffset = (double)((j & 2) - 1) * size;
                double yOffset = (double)((j + 1 & 2) - 1) * size;
                double rx = xOffset * cosRoll - yOffset * sinRoll;
                double ry = yOffset * cosRoll + xOffset * sinRoll;
                double rz = 0.0;
                double vx = ry * sinPitch + rz * cosPitch;
                double vy = rz * sinPitch - ry * cosPitch;
                double vz = vx * sinYaw - rx * cosYaw;
                double vw = rx * sinYaw + vx * cosYaw;
                builder.m_5483_((double)((float)(x + vz)), (double)((float)(y + vy)), (double)((float)(z + vw))).m_5752_();
            }
        }
        BufferBuilder.RenderedBuffer rendered = builder.m_231175_();
        starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        starBuffer.m_85921_();
        starBuffer.m_231221_(rendered);
        VertexBuffer.m_85931_();
    }

    private static void renderEndInfiniteStars(PoseStack poseStack, ClientLevel level, Camera camera) {
        Vec3 camPos = camera.m_90583_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int viewRange = 8;
        long baseSeed = 987654321L;
        int baseX = (int)Math.floor(camPos.f_82479_ / 128.0);
        int baseY = (int)Math.floor(camPos.f_82480_ / 128.0);
        int baseZ = (int)Math.floor(camPos.f_82481_ / 128.0);
        for (int rx = -viewRange; rx <= viewRange; ++rx) {
            for (int ry = -viewRange; ry <= viewRange; ++ry) {
                for (int rz = -viewRange; rz <= viewRange; ++rz) {
                    int regionX = baseX + rx;
                    int regionY = baseY + ry;
                    int regionZ = baseZ + rz;
                    long seed = baseSeed + (long)regionX * 341873128712L + (long)regionY * 132897987541L + (long)regionZ * 42317861L;
                    RandomSource random = RandomSource.m_216335_((long)seed);
                    double regionWorldX = regionX * 128;
                    double regionWorldY = regionY * 128;
                    double regionWorldZ = regionZ * 128;
                    for (int i = 0; i < 60; ++i) {
                        double z;
                        double dz;
                        double y;
                        double dy;
                        double x = regionWorldX + random.m_188500_() * 128.0;
                        double dx = x - camPos.f_82479_;
                        double distSq = dx * dx + (dy = (y = regionWorldY + random.m_188500_() * 128.0) - camPos.f_82480_) * dy + (dz = (z = regionWorldZ + random.m_188500_() * 128.0) - camPos.f_82481_) * dz;
                        if (distSq > 262144.0) continue;
                        float flicker = 0.7f + 0.3f * Mth.m_14031_((float)((float)(x * 0.01 + z * 0.01 + (double)level.m_46467_() * 0.02)));
                        float r = 0.9f + random.m_188501_() * 0.1f;
                        float g = 0.9f + random.m_188501_() * 0.1f;
                        float b = 1.0f;
                        float a = 0.8f * flicker;
                        float s = 0.05f;
                        buffer.m_252986_(matrix, (float)(dx - (double)s), (float)(dy - (double)s), (float)dz).m_85950_(r, g, b, a).m_5752_();
                        buffer.m_252986_(matrix, (float)(dx - (double)s), (float)(dy + (double)s), (float)dz).m_85950_(r, g, b, a).m_5752_();
                        buffer.m_252986_(matrix, (float)(dx + (double)s), (float)(dy + (double)s), (float)dz).m_85950_(r, g, b, a).m_5752_();
                        buffer.m_252986_(matrix, (float)(dx + (double)s), (float)(dy - (double)s), (float)dz).m_85950_(r, g, b, a).m_5752_();
                    }
                }
            }
        }
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

