/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BubblingVoidBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ENDING = BooleanProperty.m_61465_((String)"ending");

    public BubblingVoidBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_56744_).m_60978_(1.0f).m_60953_(s -> 5).m_60999_().m_60910_().m_60955_().m_60982_((bs, br, bp) -> true).m_60991_((bs, br, bp) -> true).m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ENDING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> BubblingVoidBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
            case Direction.NORTH -> BubblingVoidBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
            case Direction.EAST -> BubblingVoidBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
            case Direction.WEST -> BubblingVoidBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
            case Direction.UP -> BubblingVoidBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0);
            case Direction.DOWN -> BubblingVoidBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, ENDING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        Direction facing = context.m_7820_().m_122424_();
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        return this.updateEndingState(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    private BlockState updateEndingState(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos frontPos = pos.m_121945_(facing);
        BlockPos backPos = pos.m_121945_(facing.m_122424_());
        boolean isEnding = world.m_46859_(frontPos) && (world.m_8055_(backPos).m_60783_((BlockGetter)world, backPos, facing) || world.m_8055_(backPos).m_60734_() instanceof BubblingVoidBlock);
        return (BlockState)state.m_61124_((Property)ENDING, (Comparable)Boolean.valueOf(isEnding));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        if (!world.f_46443_) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            double speed = 0.08;
            Vec3 motion = entity.m_20184_();
            switch (facing) {
                case UP: {
                    entity.m_20334_(motion.f_82479_, Math.min(motion.f_82480_ + speed, 0.6), motion.f_82481_);
                    break;
                }
                case DOWN: {
                    entity.m_20334_(motion.f_82479_, Math.max(motion.f_82480_ - speed, -0.6), motion.f_82481_);
                    break;
                }
                case NORTH: {
                    entity.m_20334_(motion.f_82479_, motion.f_82480_, Math.max(motion.f_82481_ - speed, -0.6));
                    break;
                }
                case SOUTH: {
                    entity.m_20334_(motion.f_82479_, motion.f_82480_, Math.min(motion.f_82481_ + speed, 0.6));
                    break;
                }
                case EAST: {
                    entity.m_20334_(Math.min(motion.f_82479_ + speed, 0.6), motion.f_82480_, motion.f_82481_);
                    break;
                }
                case WEST: {
                    entity.m_20334_(Math.max(motion.f_82479_ - speed, -0.6), motion.f_82480_, motion.f_82481_);
                }
            }
            entity.f_19864_ = true;
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.m_214162_(state, world, pos, random);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        double minX = 0.25;
        double minY = 0.0;
        double minZ = 0.25;
        double maxX = 0.75;
        double maxY = 1.0;
        double maxZ = 0.75;
        double x = (double)pos.m_123341_() + minX + (maxX - minX) * random.m_188500_();
        double y = (double)pos.m_123342_() + minY + (maxY - minY) * random.m_188500_();
        double z = (double)pos.m_123343_() + minZ + (maxZ - minZ) * random.m_188500_();
        double speed = 0.02;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        switch (facing) {
            case UP: {
                vy = speed;
                break;
            }
            case DOWN: {
                vy = -speed;
                break;
            }
            case NORTH: {
                vz = -speed;
                break;
            }
            case SOUTH: {
                vz = speed;
                break;
            }
            case EAST: {
                vx = speed;
                break;
            }
            case WEST: {
                vx = -speed;
            }
        }
        world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, vx, vy, vz);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos backPos = pos.m_121945_(direction.m_122424_());
        BlockState backState = world.m_8055_(backPos);
        return backState.m_60783_((BlockGetter)world, backPos, direction) || backState.m_60734_() instanceof BubblingVoidBlock;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return !(state = this.updateEndingState(state, world, currentPos)).m_60710_((LevelReader)world, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return context.m_43722_().m_41720_() != this.m_5456_();
    }
}

