/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.block;

import java.util.Arrays;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FortuneFlowersBlock
extends Block {
    public static final int MIN_FEELERS = 1;
    public static final int MAX_FEELERS = 4;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty AMOUNT = BlockStateProperties.f_271526_;
    private static final List<VoxelShape> SHAPES = Arrays.asList(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)17.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)20.0, (double)15.0));
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = blockstate -> {
        if (blockstate.m_61138_((Property)AMOUNT)) {
            return Math.min(10, 4 + 2 * ((Integer)blockstate.m_61143_((Property)AMOUNT) - 1));
        }
        return 0;
    };

    public FortuneFlowersBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60953_(LIGHT_EMISSION::applyAsInt).m_60918_(SoundType.f_56712_).m_60978_(0.2f).m_60910_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AMOUNT});
    }

    public BlockState m_6843_(BlockState blockstate, Rotation rotation) {
        return (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockstate.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockstate, Mirror direction) {
        return blockstate.m_60717_(direction.m_54846_((Direction)blockstate.m_61143_((Property)FACING)));
    }

    public boolean m_6864_(BlockState blockstate, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)blockstate.m_61143_((Property)AMOUNT) < 4 ? true : super.m_6864_(blockstate, context);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState below = world.m_8055_(pos.m_7495_());
        return below.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("endless_heart:end_plant_blocks")));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int index = Math.max(0, Math.min(3, (Integer)state.m_61143_((Property)AMOUNT) - 1));
        return SHAPES.get(index);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState currentState = world.m_8055_(pos = context.m_8083_());
        if (currentState.m_60713_((Block)this)) {
            return (BlockState)currentState.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)currentState.m_61143_((Property)AMOUNT) + 1)));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(1));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (neighborState.m_60819_().m_76170_() || neighborState.m_60819_().m_76152_() == Fluids.f_76193_) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }
}

