/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.block.entity;

import java.util.EnumMap;
import net.mcreator.endlessheart.init.EndlessHeartModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class PitchBlockEntity
extends BlockEntity {
    private final EnumMap<Direction, Integer> faceColors = new EnumMap(Direction.class);

    public PitchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EndlessHeartModBlockEntities.PITCH.get(), pos, state);
        for (Direction dir : Direction.values()) {
            this.faceColors.put(dir, 0);
        }
    }

    public void clientInitColors() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos behindPos = this.f_58858_.m_121945_(dir);
            BlockState behindState = this.f_58857_.m_8055_(behindPos);
            MapColor mapColor = behindState.m_284242_((BlockGetter)this.f_58857_, behindPos);
            int newColor = 0xFFFFFF;
            if (mapColor != null) {
                int raw = mapColor.m_284280_(MapColor.Brightness.NORMAL);
                if (raw == 0) {
                    raw = mapColor.f_283871_;
                }
                int r = raw & 0xFF;
                int g = raw >> 8 & 0xFF;
                int b = raw >> 16 & 0xFF;
                newColor = r << 16 | g << 8 | b;
            }
            this.faceColors.put(dir, newColor);
        }
    }

    public void updateFaceColors() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        boolean changed = false;
        for (Direction dir : Direction.values()) {
            BlockPos behindPos = this.f_58858_.m_121945_(dir);
            BlockState behindState = this.f_58857_.m_8055_(behindPos);
            MapColor mapColor = behindState.m_284242_((BlockGetter)this.f_58857_, behindPos);
            int newColor = 0xFFFFFF;
            if (mapColor != null) {
                int raw = mapColor.m_284280_(MapColor.Brightness.NORMAL);
                if (raw == 0) {
                    raw = mapColor.f_283871_;
                }
                int r = raw & 0xFF;
                int g = raw >> 8 & 0xFF;
                int b = raw >> 16 & 0xFF;
                newColor = r << 16 | g << 8 | b;
            }
            if (this.faceColors.get(dir) == newColor) continue;
            this.faceColors.put(dir, newColor);
            changed = true;
        }
        if (changed) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int getFaceColor(Direction dir) {
        return this.faceColors.getOrDefault(dir, 0xFFFFFF);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        for (Direction dir : Direction.values()) {
            tag.m_128405_(dir.m_122433_() + "Color", this.faceColors.get(dir).intValue());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        for (Direction dir : Direction.values()) {
            if (!tag.m_128441_(dir.m_122433_() + "Color")) continue;
            this.faceColors.put(dir, tag.m_128451_(dir.m_122433_() + "Color"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

