/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.custom.world.configured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class CustomColumnsFeature
extends Feature<Configuration> {
    public CustomColumnsFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        Configuration config = (Configuration)context.m_159778_();
        int radius = config.reach().m_214085_(random);
        if (radius < 1) {
            return false;
        }
        int minHeight = config.height().m_142739_();
        int maxHeight = config.height().m_142737_();
        boolean placedAny = false;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos pos;
                BlockPos.MutableBlockPos surface;
                int distSq = dx * dx + dz * dz;
                if (distSq > radius * radius || (surface = this.findSurface((LevelAccessor)level, (pos = origin.m_7918_(dx, 0, dz)).m_122032_())) == null) continue;
                float distance = (float)Math.sqrt(distSq) / (float)radius;
                float heightFactor = 1.0f - distance;
                int heightRange = maxHeight - minHeight;
                int columnHeight = minHeight + Math.round((float)heightRange * heightFactor);
                int terrainDepth = config.terrainReplace().m_214085_(random);
                placedAny |= this.placeColumn((LevelAccessor)level, (BlockPos)surface, columnHeight, config.block(), config.terrainBlock(), terrainDepth, random);
            }
        }
        return placedAny;
    }

    private BlockPos.MutableBlockPos findSurface(LevelAccessor level, BlockPos.MutableBlockPos pos) {
        while (pos.m_123342_() > level.m_141937_() + 1) {
            BlockState below = level.m_8055_(pos.m_7495_());
            if (!below.m_60795_() && below.m_60815_()) {
                return pos;
            }
            pos.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private boolean placeColumn(LevelAccessor level, BlockPos start, int height, BlockStateProvider block, BlockStateProvider terrain, int terrainDepth, RandomSource random) {
        boolean placed = false;
        BlockPos.MutableBlockPos current = start.m_122032_();
        for (int i = 0; i < height && level.m_46859_((BlockPos)current); ++i) {
            BlockState state = i < terrainDepth ? terrain.m_213972_(random, (BlockPos)current) : block.m_213972_(random, (BlockPos)current);
            level.m_7731_((BlockPos)current, state, 2);
            current.m_122173_(Direction.UP);
            placed = true;
        }
        return placed;
    }

    public record Configuration(IntProvider reach, IntProvider height, BlockStateProvider block, BlockStateProvider terrainBlock, IntProvider terrainReplace) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.m_146545_((int)0, (int)8).fieldOf("reach").forGetter(Configuration::reach), (App)IntProvider.m_146545_((int)1, (int)20).fieldOf("height").forGetter(Configuration::height), (App)BlockStateProvider.f_68747_.fieldOf("block").forGetter(Configuration::block), (App)BlockStateProvider.f_68747_.fieldOf("terrain_block").forGetter(Configuration::terrainBlock), (App)IntProvider.m_146545_((int)0, (int)10).fieldOf("terrain_replace").forGetter(Configuration::terrainReplace)).apply((Applicative)instance, Configuration::new));
    }
}

