/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.custom.world.configured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class CustomCrystalFeature
extends Feature<Configuration> {
    public CustomCrystalFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        Configuration config = (Configuration)context.m_159778_();
        int solidCount = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-1, -1, -1), (BlockPos)origin.m_7918_(1, -1, 1))) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60795_() || state.m_278721_()) continue;
            ++solidCount;
        }
        if (solidCount < 4 || !world.m_7433_(origin, DripstoneUtils::m_159664_)) {
            return false;
        }
        float width = config.width().m_214084_(random);
        float height = config.height().m_214084_(random);
        this.generateBoulder(world, origin.m_7494_(), random, config, width, height);
        if (config.modifyTerrain()) {
            this.modifyTerrain(world, origin, random, width, config);
        }
        return true;
    }

    private void generateBoulder(WorldGenLevel world, BlockPos origin, RandomSource random, Configuration config, float width, float height) {
        float radiusX = width;
        float radiusY = height;
        float radiusZ = width;
        HashMap<BlockPos, BlockPos> topBlocks = new HashMap<BlockPos, BlockPos>();
        for (float x = -radiusX; x <= radiusX; x += 1.0f) {
            for (float y = -radiusY; y <= radiusY; y += 1.0f) {
                for (float z = -radiusZ; z <= radiusZ; z += 1.0f) {
                    double dx = x / radiusX;
                    double dy = y / radiusY;
                    double dz = z / radiusZ;
                    double distance = dx * dx + dy * dy + dz * dz;
                    if (!(distance <= 1.0)) continue;
                    BlockPos pos = BlockPos.m_274561_((double)((float)origin.m_123341_() + x), (double)((float)origin.m_123342_() + y), (double)((float)origin.m_123343_() + z));
                    BlockState state = config.boulderBlock().m_213972_(random, pos);
                    world.m_7731_(pos, state, 3);
                    BlockPos colKey = new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
                    topBlocks.compute(colKey, (k, current) -> current == null || pos.m_123342_() > current.m_123342_() ? pos : current);
                }
            }
        }
        for (BlockPos topPos : topBlocks.values()) {
            if (!world.m_46859_(topPos.m_7494_())) continue;
            float chance = config.crystalChance().m_214084_(random);
            if (!(random.m_188501_() < chance)) continue;
            BlockState crystal = config.crystalBlock().m_213972_(random, topPos.m_7494_());
            world.m_7731_(topPos.m_7494_(), crystal, 3);
        }
    }

    private void modifyTerrain(WorldGenLevel world, BlockPos origin, RandomSource random, float radiusFactor, Configuration config) {
        int radius = (int)(radiusFactor * 1.8f);
        BlockPos.m_121985_((BlockPos)origin, (int)radius, (int)3, (int)radius).forEach(pos -> {
            BlockState targetState = world.m_8055_(pos);
            if (config.replaceTerrain().m_213972_(random, pos).m_60713_(targetState.m_60734_())) {
                int distance = Math.abs(pos.m_123341_() - origin.m_123341_()) + Math.abs(pos.m_123342_() - origin.m_123342_()) + Math.abs(pos.m_123343_() - origin.m_123343_());
                float falloff = 1.0f - (float)distance / (float)radius;
                if (random.m_188501_() < falloff) {
                    BlockState terrain = config.terrainBlock().m_213972_(random, pos);
                    world.m_7731_(pos, terrain, 3);
                }
            }
        });
    }

    public record Configuration(BlockStateProvider boulderBlock, BlockStateProvider terrainBlock, BlockStateProvider replaceTerrain, boolean modifyTerrain, FloatProvider width, FloatProvider height, BlockStateProvider crystalBlock, FloatProvider crystalChance) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("boulder_block").forGetter(Configuration::boulderBlock), (App)BlockStateProvider.f_68747_.fieldOf("terrain_block").forGetter(Configuration::terrainBlock), (App)BlockStateProvider.f_68747_.fieldOf("replace_terrain").forGetter(Configuration::replaceTerrain), (App)Codec.BOOL.fieldOf("modify_terrain").forGetter(Configuration::modifyTerrain), (App)FloatProvider.f_146502_.fieldOf("width").forGetter(Configuration::width), (App)FloatProvider.f_146502_.fieldOf("height").forGetter(Configuration::height), (App)BlockStateProvider.f_68747_.fieldOf("crystal_block").forGetter(Configuration::crystalBlock), (App)FloatProvider.f_146502_.fieldOf("crystal_chance").forGetter(Configuration::crystalChance)).apply((Applicative)instance, Configuration::new));
    }
}

