/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.custom.world.configured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class CustomLakeFeature
extends Feature<Configuration> {
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();

    public CustomLakeFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        int x;
        int z;
        int x2;
        BlockPos origin = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        RandomSource random = context.m_225041_();
        Configuration config = (Configuration)context.m_159778_();
        int width = config.width;
        int depth = config.depth;
        if (origin.m_123342_() <= world.m_141937_() + depth) {
            return false;
        }
        origin = origin.m_6625_(depth);
        int arraySize = width * width * depth;
        boolean[] mask = new boolean[arraySize];
        int blobs = random.m_188503_(4) + 4;
        for (int i = 0; i < blobs; ++i) {
            double dx = random.m_188500_() * ((double)width * 0.4) + (double)width * 0.3;
            double dy = random.m_188500_() * ((double)depth * 0.4) + (double)depth * 0.3;
            double dz = random.m_188500_() * ((double)width * 0.4) + (double)width * 0.3;
            double cx = random.m_188500_() * ((double)width - dx - 2.0) + 1.0 + dx / 2.0;
            double cy = random.m_188500_() * ((double)depth - dy - 2.0) + 1.0 + dy / 2.0;
            double cz = random.m_188500_() * ((double)width - dz - 2.0) + 1.0 + dz / 2.0;
            for (int x3 = 0; x3 < width; ++x3) {
                for (int z2 = 0; z2 < width; ++z2) {
                    for (int y = 0; y < depth; ++y) {
                        double nx = ((double)x3 - cx) / (dx / 2.0);
                        double ny = ((double)y - cy) / (dy / 2.0);
                        double nz = ((double)z2 - cz) / (dz / 2.0);
                        if (!(nx * nx + ny * ny + nz * nz < 1.0)) continue;
                        mask[(x3 * width + z2) * depth + y] = true;
                    }
                }
            }
        }
        BlockState fluid = config.fluid().m_213972_(random, origin);
        for (x2 = 0; x2 < width; ++x2) {
            for (z = 0; z < width; ++z) {
                for (int y = 0; y < depth; ++y) {
                    boolean edge;
                    boolean bl = edge = !mask[(x2 * width + z) * depth + y] && (x2 < width - 1 && mask[((x2 + 1) * width + z) * depth + y] || x2 > 0 && mask[((x2 - 1) * width + z) * depth + y] || z < width - 1 && mask[(x2 * width + z + 1) * depth + y] || z > 0 && mask[(x2 * width + (z - 1)) * depth + y] || y < depth - 1 && mask[(x2 * width + z) * depth + y + 1] || y > 0 && mask[(x2 * width + z) * depth + (y - 1)]);
                    if (!edge) continue;
                    BlockState current = world.m_8055_(origin.m_7918_(x2, y, z));
                    if (y >= depth / 2 && current.m_278721_()) {
                        return false;
                    }
                    if (y >= depth / 2 || current.m_280296_() || current.m_60795_()) continue;
                    return false;
                }
            }
        }
        for (x2 = 0; x2 < width; ++x2) {
            for (z = 0; z < width; ++z) {
                for (int y = 0; y < depth; ++y) {
                    if (!mask[(x2 * width + z) * depth + y]) continue;
                    BlockPos pos = origin.m_7918_(x2, y, z);
                    boolean air = y >= depth / 2;
                    world.m_7731_(pos, air ? AIR : fluid, 2);
                    if (!air) continue;
                    world.m_186460_(pos, AIR.m_60734_(), 0);
                    this.m_159739_(world, pos);
                }
            }
        }
        BlockState barrier = config.barrier().m_213972_(random, origin);
        if (!barrier.m_60795_()) {
            for (x = 0; x < width; ++x) {
                for (int z3 = 0; z3 < width; ++z3) {
                    for (int y = 0; y < depth; ++y) {
                        BlockPos pos;
                        BlockState current;
                        boolean edge;
                        boolean bl = edge = !mask[(x * width + z3) * depth + y] && (x < width - 1 && mask[((x + 1) * width + z3) * depth + y] || x > 0 && mask[((x - 1) * width + z3) * depth + y] || z3 < width - 1 && mask[(x * width + z3 + 1) * depth + y] || z3 > 0 && mask[(x * width + (z3 - 1)) * depth + y] || y < depth - 1 && mask[(x * width + z3) * depth + y + 1] || y > 0 && mask[(x * width + z3) * depth + (y - 1)]);
                        if (!edge || y >= depth / 2 && random.m_188503_(2) != 0 || !(current = world.m_8055_(pos = origin.m_7918_(x, y, z3))).m_280296_() || current.m_204336_(BlockTags.f_144288_)) continue;
                        world.m_7731_(pos, barrier, 2);
                        this.m_159739_(world, pos);
                    }
                }
            }
        }
        if (fluid.m_60819_().m_205070_(FluidTags.f_13131_)) {
            for (x = 0; x < width; ++x) {
                for (int z4 = 0; z4 < width; ++z4) {
                    BlockPos freezePos = origin.m_7918_(x, depth / 2, z4);
                    if (!((Biome)world.m_204166_(freezePos).m_203334_()).m_47480_((LevelReader)world, freezePos, false) || !this.canReplaceBlock(world.m_8055_(freezePos))) continue;
                    world.m_7731_(freezePos, Blocks.f_50126_.m_49966_(), 2);
                }
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.m_204336_(BlockTags.f_144287_);
    }

    public record Configuration(BlockStateProvider fluid, BlockStateProvider barrier, int width, int depth) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("fluid").forGetter(Configuration::fluid), (App)BlockStateProvider.f_68747_.fieldOf("barrier").forGetter(Configuration::barrier), (App)Codec.INT.fieldOf("width").forGetter(Configuration::width), (App)Codec.INT.fieldOf("depth").forGetter(Configuration::depth)).apply((Applicative)instance, Configuration::new));
    }
}

