/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.custom.world.configured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class CustomSpikeFeature
extends Feature<Configuration> {
    public CustomSpikeFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        Configuration config = (Configuration)context.m_159778_();
        int radius = config.radius().m_214085_(random);
        int height = config.height().m_214085_(random);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(origin.m_123341_() - radius, level.m_141937_(), origin.m_123343_() - radius), (BlockPos)new BlockPos(origin.m_123341_() + radius, origin.m_123342_() + height + 10, origin.m_123343_() + radius))) {
            if (pos.m_203202_((double)origin.m_123341_(), (double)pos.m_123342_(), (double)origin.m_123343_()) <= (double)(radius * radius + 1) && pos.m_123342_() < origin.m_123342_() + height) {
                BlockState state = config.blockProvider().m_213972_(random, pos);
                this.m_5974_((LevelWriter)level, pos, state);
                continue;
            }
            if (pos.m_123342_() <= 65) continue;
            this.m_5974_((LevelWriter)level, pos, Blocks.f_50016_.m_49966_());
        }
        if (random.m_188501_() < config.cageChance().m_214084_(random)) {
            BlockPos.MutableBlockPos cagePos = new BlockPos.MutableBlockPos();
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    for (int dy = 0; dy <= 3; ++dy) {
                        boolean isTop;
                        boolean isEdgeX = Math.abs(dx) == 2;
                        boolean isEdgeZ = Math.abs(dz) == 2;
                        boolean bl = isTop = dy == 3;
                        if (!isEdgeX && !isEdgeZ && !isTop) continue;
                        BlockState bars = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50183_.m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(isEdgeX && dz != -2))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(isEdgeX && dz != 2))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(isEdgeZ && dx != -2))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(isEdgeZ && dx != 2));
                        cagePos.m_122178_(origin.m_123341_() + dx, origin.m_123342_() + height + dy, origin.m_123343_() + dz);
                        this.m_5974_((LevelWriter)level, (BlockPos)cagePos, bars);
                    }
                }
            }
        }
        if (random.m_188501_() < config.crystalChance().m_214084_(random)) {
            BlockPos top = new BlockPos(origin.m_123341_(), origin.m_123342_() + height, origin.m_123343_());
            this.m_5974_((LevelWriter)level, top, Blocks.f_50752_.m_49966_());
            EndCrystal crystal = (EndCrystal)EntityType.f_20564_.m_20615_((Level)level.m_6018_());
            if (crystal != null) {
                crystal.m_20331_(false);
                crystal.m_7678_((double)origin.m_123341_() + 0.5, (double)(origin.m_123342_() + height + 1), (double)origin.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)crystal);
            }
        }
        return true;
    }

    public record Configuration(BlockStateProvider blockProvider, IntProvider radius, IntProvider height, FloatProvider cageChance, FloatProvider crystalChance) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("block").forGetter(Configuration::blockProvider), (App)IntProvider.f_146531_.fieldOf("radius").forGetter(Configuration::radius), (App)IntProvider.f_146531_.fieldOf("height").forGetter(Configuration::height), (App)FloatProvider.f_146502_.fieldOf("cage_chance").forGetter(Configuration::cageChance), (App)FloatProvider.f_146502_.fieldOf("crystal_chance").forGetter(Configuration::crystalChance)).apply((Applicative)instance, Configuration::new));
    }
}

