/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.mcreator.endlessheart.entity.BlastlingFireProjectileEntity;
import net.mcreator.endlessheart.entity.EndersentEntity;
import net.mcreator.endlessheart.init.EndlessHeartModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BlastlingEntity
extends EnderMan
implements RangedAttackMob {
    private boolean hasTarget;
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(BlastlingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(EndersentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public BlastlingEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BlastlingEntity>)((EntityType)EndlessHeartModEntities.BLASTLING.get()), world);
    }

    public BlastlingEntity(EntityType<BlastlingEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 5;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BlastlingStrafeGoal(this, 1.0, 10, 12.0f));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasTarget", this.hasTarget);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.hasTarget = compound.m_128471_("HasTarget");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_TARGET, (Object)false);
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (target == null) {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
        } else {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
        }
    }

    public boolean m_32531_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.hasTarget = true;
        } else if (id == 11) {
            this.hasTarget = false;
        } else {
            super.m_7822_(id);
        }
    }

    public void setHasTarget(boolean value) {
        if (this.hasTarget != value) {
            this.hasTarget = value;
            this.f_19804_.m_135381_(HAS_TARGET, (Object)value);
            this.m_9236_().m_7605_((Entity)this, value ? (byte)10 : 11);
        }
    }

    public boolean getHasTarget() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(HAS_TARGET) : this.hasTarget;
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        this.setHasTarget(this.m_5448_() != null);
        if (!this.m_9236_().f_46443_ && (target = this.m_5448_()) != null) {
            this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 2.375f;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268565_) || damagesource.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_6128_() {
        return true;
    }

    public void m_6504_(LivingEntity target, float flval) {
        BlastlingFireProjectileEntity.shoot((LivingEntity)this, target);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)EndlessHeartModEntities.BLASTLING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder m_32541_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 60.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22281_, 9.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.1);
        return builder;
    }

    public class BlastlingStrafeGoal
    extends Goal {
        private final RangedAttackMob shooter;
        private final Mob mob;
        private final double speed;
        private final float attackRangeSqr;
        private int attackCooldown;
        private int seeTime;
        private int strafingTime = -1;
        private boolean strafingClockwise;
        private boolean strafingBackwards;

        public BlastlingStrafeGoal(RangedAttackMob shooter, double speed, int attackCooldown, float attackRange) {
            this.shooter = shooter;
            this.mob = (Mob)shooter;
            this.speed = speed;
            this.attackCooldown = attackCooldown;
            this.attackRangeSqr = attackRange * attackRange;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.mob.m_5448_() != null;
        }

        public void m_8056_() {
            this.strafingClockwise = this.mob.m_217043_().m_188499_();
            this.strafingBackwards = false;
            this.strafingTime = 0;
        }

        public void m_8041_() {
            this.strafingTime = -1;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = this.mob.m_21574_().m_148306_((Entity)target);
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (distance > (double)this.attackRangeSqr * 1.2) {
                this.mob.m_21573_().m_5624_((Entity)target, this.speed);
                return;
            }
            this.mob.m_21573_().m_26573_();
            if (this.strafingTime <= 0) {
                this.strafingTime = 20 + this.mob.m_217043_().m_188503_(10);
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
            }
            --this.strafingTime;
            if (canSee) {
                float strafeSpeed = 0.5f;
                this.mob.m_21566_().m_24988_(this.strafingBackwards ? -strafeSpeed : strafeSpeed, this.strafingClockwise ? 0.5f : -0.5f);
            }
            if (distance <= (double)this.attackRangeSqr && --this.attackCooldown <= 0) {
                this.shooter.m_6504_(target, 1.0f);
                this.attackCooldown = 10;
            }
        }
    }
}

