/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.endlessheart.init.EndlessHeartModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class EndersentEntity
extends EnderMan {
    private int attackAnimationTick;
    private static final EntityDataAccessor<Boolean> ENDERSENT_EYE = SynchedEntityData.m_135353_(EndersentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(EndersentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EndersentEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<EndersentEntity>)((EntityType)EndlessHeartModEntities.ENDERSENT.get()), world);
    }

    public EndersentEntity(EntityType<EndersentEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 8;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    protected float m_6431_(Pose p_32517_, EntityDimensions p_32518_) {
        return 4.2f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public boolean m_7327_(Entity target) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float attackDamage = (float)this.m_21133_(Attributes.f_22281_);
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), attackDamage);
        if (flag) {
            this.m_19970_((LivingEntity)this, target);
            double knockbackStrength = this.m_21133_(Attributes.f_22282_);
            if (knockbackStrength > 0.0) {
                double dx = target.m_20185_() - this.m_20185_();
                double dz = target.m_20189_() - this.m_20189_();
                double distance = Math.max(Math.sqrt(dx * dx + dz * dz), 0.01);
                double knockbackX = dx / distance * knockbackStrength * 0.6;
                double knockbackZ = dz / distance * knockbackStrength * 0.6;
                double knockbackY = 0.7 * knockbackStrength;
                target.m_20256_(target.m_20184_().m_82520_(knockbackX, knockbackY, knockbackZ));
            }
        }
        return flag;
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (target == null) {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
        } else {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
        }
    }

    public boolean m_32531_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
        this.f_19804_.m_135372_(ENDERSENT_EYE, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("EndersentEye", this.hasEndersentEye());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setEndersentEye(tag.m_128471_("EndersentEye"));
    }

    public boolean hasEndersentEye() {
        return (Boolean)this.f_19804_.m_135370_(ENDERSENT_EYE);
    }

    public void setEndersentEye(boolean hasEye) {
        this.f_19804_.m_135381_(ENDERSENT_EYE, (Object)hasEye);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.death"));
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.hasEndersentEye()) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42545_));
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        this.setEndersentEye(new Random().nextInt(3) == 0);
        return retval;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)EndlessHeartModEntities.ENDERSENT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder m_32541_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.1);
        builder = builder.m_22268_(Attributes.f_22276_, 120.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 20.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        builder = builder.m_22268_(Attributes.f_22282_, 1.5);
        return builder;
    }
}

