/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.item;

import java.util.Optional;
import net.mcreator.endlessheart.block.EnderCheckpointBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EnderCommunicatorItem
extends Item {
    private static final String KEY_POS = "CheckpointPos";
    private static final String KEY_DIM = "CheckpointDim";

    public EnderCommunicatorItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state;
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (player != null && player.m_6144_() && (state = level.m_8055_(pos)).m_60734_() instanceof EnderCheckpointBlock && (Integer)state.m_61143_((Property)EnderCheckpointBlock.CHARGES) > 0) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128356_(KEY_POS, pos.m_121878_());
            tag.m_128359_(KEY_DIM, level.m_46472_().m_135782_().toString());
            player.m_5661_((Component)Component.m_237113_((String)"Binded communicator to checkpoint!"), true);
            level.m_5594_(null, pos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(KEY_POS) || !tag.m_128441_(KEY_DIM)) {
            player.m_5661_((Component)Component.m_237113_((String)"No checkpoint found!"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockPos pos = BlockPos.m_122022_((long)tag.m_128454_(KEY_POS));
        ResourceKey boundDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(KEY_DIM)));
        if (!level.m_46472_().equals((Object)boundDim)) {
            player.m_5661_((Component)Component.m_237113_((String)"No checkpoint found!"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_6144_()) {
            if (!level.f_46443_ && level instanceof ServerLevel) {
                Optional<Vec3> safe;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState state = serverLevel.m_8055_(pos);
                if (state.m_60734_() instanceof EnderCheckpointBlock && (Integer)state.m_61143_((Property)EnderCheckpointBlock.CHARGES) > 0 && (safe = EnderCheckpointBlock.findSafeRespawnPosition(EntityType.f_20532_, (CollisionGetter)serverLevel, pos)).isPresent()) {
                    Vec3 target = safe.get();
                    serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)EnderCheckpointBlock.CHARGES, (Comparable)Integer.valueOf(0)), 3);
                    Vec3 oldPos = player.m_20182_();
                    player.m_20324_(target.f_82479_, target.f_82480_, target.f_82481_);
                    serverLevel.m_5594_(null, pos, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, oldPos.f_82479_, oldPos.f_82480_ + 1.0, oldPos.f_82481_, 50, 0.5, 0.5, 0.5, 0.1);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, target.f_82479_, target.f_82480_ + 1.0, target.f_82481_, 50, 0.5, 0.5, 0.5, 0.1);
                    player.m_5661_((Component)Component.m_237113_((String)"Checkpoint teleported!"), true);
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                player.m_5661_((Component)Component.m_237113_((String)"No checkpoint found!"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        } else {
            double dx = Math.abs(player.m_20185_() - ((double)pos.m_123341_() + 0.5));
            double dy = Math.abs(player.m_20186_() - ((double)pos.m_123342_() + 0.5));
            double dz = Math.abs(player.m_20189_() - ((double)pos.m_123343_() + 0.5));
            player.m_5661_((Component)Component.m_237113_((String)String.format("Checkpoint: X: %.1f, Y: %.1f, Z: %.1f", dx, dy, dz)), true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

