/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.mixins;

import java.util.Comparator;
import java.util.List;
import net.mcreator.endlessheart.IShulkerTamable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CarvedPumpkinBlock.class})
public abstract class CarvedPumpkinBlockMixin {
    @Inject(method={"trySpawnGolem"}, at={@At(value="TAIL")})
    private void injectShulkerGolem(Level level, BlockPos pumpkinPos, CallbackInfo ci) {
        Direction[] dirs;
        if (level.f_46443_) {
            return;
        }
        for (Direction dir : dirs = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            Direction uDir;
            BlockPos center = pumpkinPos.m_121945_(dir.m_122424_());
            Direction vDir = switch (dir) {
                case Direction.UP, Direction.DOWN -> {
                    uDir = Direction.EAST;
                    yield Direction.SOUTH;
                }
                case Direction.NORTH, Direction.SOUTH -> {
                    uDir = Direction.EAST;
                    yield Direction.UP;
                }
                default -> {
                    uDir = Direction.SOUTH;
                    yield Direction.UP;
                }
            };
            BlockPos topLayerOrigin = center.m_121945_(dir);
            BlockPos bottomLayerOrigin = center;
            boolean topOk = true;
            block5: for (int du = -1; du <= 1 && topOk; ++du) {
                for (int dv = -1; dv <= 1; ++dv) {
                    BlockPos pos = topLayerOrigin.m_7918_(uDir.m_122429_() * du + vDir.m_122429_() * dv, uDir.m_122430_() * du + vDir.m_122430_() * dv, uDir.m_122431_() * du + vDir.m_122431_() * dv);
                    if (du == 0 && dv == 0) {
                        if (level.m_8055_(pos).m_60713_(Blocks.f_50143_)) continue;
                        topOk = false;
                        continue block5;
                    }
                    if (level.m_8055_(pos).m_60795_()) continue;
                    topOk = false;
                    continue block5;
                }
            }
            if (!topOk) continue;
            boolean bottomOk = true;
            block7: for (int du = -1; du <= 1 && bottomOk; ++du) {
                for (int dv = -1; dv <= 1; ++dv) {
                    BlockPos pos = bottomLayerOrigin.m_7918_(uDir.m_122429_() * du + vDir.m_122429_() * dv, uDir.m_122430_() * du + vDir.m_122430_() * dv, uDir.m_122431_() * du + vDir.m_122431_() * dv);
                    if (du == 0 && dv == 0) {
                        if (level.m_8055_(pos).m_60713_(Blocks.f_50259_)) continue;
                        bottomOk = false;
                        continue block7;
                    }
                    if (Math.abs(du) + Math.abs(dv) == 1) {
                        if (level.m_8055_(pos).m_60713_(Blocks.f_50492_)) continue;
                        bottomOk = false;
                        continue block7;
                    }
                    if (level.m_8055_(pos).m_60795_()) continue;
                    bottomOk = false;
                    continue block7;
                }
            }
            if (!bottomOk) continue;
            Shulker shulker = (Shulker)EntityType.f_20521_.m_20615_(level);
            if (shulker == null) {
                return;
            }
            shulker.m_7678_((double)center.m_123341_() + 0.5, (double)center.m_123342_(), (double)center.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)shulker);
            Player owner = null;
            List nearbyPlayers = level.m_45976_(Player.class, shulker.m_20191_().m_82400_(8.0));
            if (!nearbyPlayers.isEmpty()) {
                owner = nearbyPlayers.stream().min(Comparator.comparingDouble(p -> p.m_20280_((Entity)shulker))).orElse(null);
            }
            if (owner != null && shulker instanceof IShulkerTamable) {
                IShulkerTamable tameable = (IShulkerTamable)shulker;
                tameable.tame(owner);
            }
            for (int layer = 0; layer <= 1; ++layer) {
                BlockPos origin = layer == 0 ? topLayerOrigin : bottomLayerOrigin;
                for (int du = -1; du <= 1; ++du) {
                    for (int dv = -1; dv <= 1; ++dv) {
                        BlockPos pos = origin.m_7918_(uDir.m_122429_() * du + vDir.m_122429_() * dv, uDir.m_122430_() * du + vDir.m_122430_() * dv, uDir.m_122431_() * du + vDir.m_122431_() * dv);
                        BlockState state = level.m_8055_(pos);
                        if (state.m_60795_()) continue;
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    }
                }
            }
            for (ServerPlayer player : level.m_45976_(ServerPlayer.class, shulker.m_20191_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(player, (Entity)shulker);
            }
            CarvedPumpkinBlock.m_246758_((Level)level, null);
            return;
        }
    }
}

