/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.mixins;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class ElytraFlightMixin {
    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V", shift=At.Shift.AFTER)})
    private void forgeMaster$elytraThrustControl(Vec3 travelVec, CallbackInfo ci) {
        double len;
        LivingEntity self = (LivingEntity)this;
        if (!(self instanceof Player)) {
            return;
        }
        Player player = (Player)self;
        if (!player.m_21255_()) {
            return;
        }
        Level level = player.m_9236_();
        if (player.m_20069_() || player.isInFluidType(level.m_6425_(player.m_20183_()).getFluidType())) {
            player.m_36321_();
            return;
        }
        Vec3 motion = player.m_20184_();
        Vec3 look = player.m_20154_();
        float forward = player.f_20902_;
        double accel = 0.025;
        double brake = 0.92;
        double maxSpeed = 1.6;
        if (forward > 0.0f && look.f_82480_ <= 0.0) {
            Vec3 thrust = look.m_82490_(accel);
            motion = motion.m_82549_(thrust);
        }
        if (forward < 0.0f && (motion = motion.m_82490_(brake)).m_82556_() < 0.05) {
            player.m_36321_();
        }
        if ((len = motion.m_82553_()) > maxSpeed) {
            motion = motion.m_82490_(maxSpeed / len);
        }
        player.m_20256_(motion);
        double speed = motion.m_82553_();
        if (speed < 0.25) {
            return;
        }
        AABB hitbox = player.m_20191_().m_82377_(1.0, 0.5, 1.0);
        List entities = level.m_6249_((Entity)player, hitbox, e -> e instanceof LivingEntity && e.m_6084_() && e != player);
        if (entities.isEmpty()) {
            return;
        }
        Vec3 direction = motion.m_82541_();
        int hitCount = 0;
        for (Entity target : entities) {
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)target;
            double knockback = Math.min(1.5, speed * 0.3);
            target.m_5997_(direction.f_82479_ * knockback, direction.f_82480_ * knockback, direction.f_82481_ * knockback);
            living.m_6469_(level.m_269111_().m_269515_(), (float)(speed * 2.0));
            ++hitCount;
        }
        if (hitCount > 0) {
            double lossFactor = 1.0 - 0.15 * (double)hitCount;
            if (lossFactor < 0.4) {
                lossFactor = 0.4;
            }
            player.m_20256_(player.m_20184_().m_82490_(lossFactor));
        }
    }
}

