/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.endlessheart.mixins;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.endlessheart.IShulkerTamable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Shulker.class})
public abstract class ShulkerColorMixin
extends Mob
implements IShulkerTamable {
    @Unique
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(ShulkerColorMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Unique
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(ShulkerColorMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Unique
    private EntityType<?> memorizedTargetType;
    @Unique
    private int ownerAttackTimestamp;

    protected ShulkerColorMixin(EntityType<? extends Mob> type, Level level) {
        super(type, level);
    }

    @Shadow
    public abstract Optional<DyeColor> m_28554_();

    @Shadow
    public abstract void m_28464_(Optional<DyeColor> var1);

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void endlessheart$defineTameSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
    }

    @Override
    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    private void setTame(boolean tame) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (tame) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    @Nullable
    private UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    private void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    @Override
    @Nullable
    public Player getOwner() {
        UUID uuid = this.getOwnerUUID();
        return uuid == null ? null : this.m_9236_().m_46003_(uuid);
    }

    public boolean m_6779_(LivingEntity entity) {
        return this.isOwnedBy(entity) ? false : super.m_6779_(entity);
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity != null && entity == this.getOwner();
    }

    public Team m_5647_() {
        Player livingentity;
        if (this.isTame() && (livingentity = this.getOwner()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity entity) {
        if (this.isTame()) {
            Player livingentity = this.getOwner();
            if (entity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Shulker shulker = (Shulker)this;
        Level level = shulker.m_9236_();
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            if (this.getOwner() == player) {
                DyeColor newColor = dyeItem.m_41089_();
                Optional currentColor = shulker.m_28554_();
                if (currentColor.isEmpty() || currentColor.get() != newColor) {
                    shulker.m_28464_(Optional.of(newColor));
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    level.m_5594_(null, shulker.m_20183_(), SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        if (this.isTame() && this.getOwner() == player && stack.m_150930_(Items.f_42731_)) {
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                level.m_5594_(null, shulker.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                for (int i = 0; i < 4; ++i) {
                    double dx = shulker.m_20208_(0.5);
                    double dy = shulker.m_20187_();
                    double dz = shulker.m_20262_(0.5);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, dx, dy + 0.3, dz, 0.0, 0.0, 0.0);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void endlessheart$addTameData(CompoundTag tag, CallbackInfo ci) {
        if (this.getOwnerUUID() != null) {
            tag.m_128362_("Owner", this.getOwnerUUID());
        }
        tag.m_128379_("Tamed", this.isTame());
        if (this.memorizedTargetType != null) {
            tag.m_128359_("MemorizedTarget", EntityType.m_20613_(this.memorizedTargetType).toString());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void endlessheart$readTameData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128403_("Owner")) {
            this.setOwnerUUID(tag.m_128342_("Owner"));
        }
        this.setTame(tag.m_128471_("Tamed"));
        if (tag.m_128441_("MemorizedTarget")) {
            this.memorizedTargetType = EntityType.m_20632_((String)tag.m_128461_("MemorizedTarget")).orElse(null);
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void endlessheart$addTameGoals(CallbackInfo ci) {
        this.f_21346_.m_25352_(5, (Goal)new RememberedTypeTargetGoal(this));
    }

    @Unique
    static class RememberedTypeTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        private final ShulkerColorMixin shulker;

        public RememberedTypeTargetGoal(ShulkerColorMixin shulker) {
            super((Mob)shulker, LivingEntity.class, true);
            this.shulker = shulker;
        }

        public boolean m_8036_() {
            List nearby;
            if (!this.shulker.isTame()) {
                return false;
            }
            Player owner = this.shulker.getOwner();
            if (owner == null) {
                return false;
            }
            LivingEntity lastHurt = owner.m_21214_();
            int attackTime = owner.m_21215_();
            if (lastHurt != null && attackTime != this.shulker.ownerAttackTimestamp && lastHurt.m_6084_()) {
                if (lastHurt == owner) {
                    return false;
                }
                this.shulker.memorizedTargetType = lastHurt.m_6095_();
                this.shulker.ownerAttackTimestamp = attackTime;
            }
            if (this.shulker.memorizedTargetType != null && !(nearby = this.shulker.m_9236_().m_6443_(LivingEntity.class, this.shulker.m_20191_().m_82400_(16.0), e -> {
                IShulkerTamable t;
                return e.m_6084_() && e.m_6095_() == this.shulker.memorizedTargetType && e != owner && (!(e instanceof IShulkerTamable) || (t = (IShulkerTamable)e).getOwner() != owner);
            })).isEmpty()) {
                this.f_26050_ = (LivingEntity)nearby.get(0);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            if (this.f_26050_ != null) {
                this.shulker.m_6710_(this.f_26050_);
                super.m_8056_();
            }
        }

        protected boolean m_26150_(@Nullable LivingEntity target, TargetingConditions conds) {
            IShulkerTamable t;
            if (target == null) {
                return false;
            }
            Player owner = this.shulker.getOwner();
            if (target == owner) {
                return false;
            }
            if (target instanceof IShulkerTamable && (t = (IShulkerTamable)target).getOwner() == owner) {
                return false;
            }
            return target.m_6095_() == this.shulker.memorizedTargetType;
        }
    }
}

