package com.debugger.entity.nbt;

import net.minecraft.class_124;
import net.minecraft.class_2520;

public enum NbtType {
    END(class_2520.field_33250, class_124.field_1068),
    BYTE(class_2520.field_33251, class_124.field_1078),
    SHORT(class_2520.field_33252, class_124.field_1065),
    INT(class_2520.field_33253, class_124.field_1065),
    LONG(class_2520.field_33254, class_124.field_1065),
    FLOAT(class_2520.field_33255, class_124.field_1065),
    DOUBLE(class_2520.field_33256, class_124.field_1065),
    STRING(class_2520.field_33258, class_124.field_1060),
    LIST(class_2520.field_33259, class_124.field_1062),
    COMPOUND(class_2520.field_33260, class_124.field_1063);

    private final byte typeId;
    private final class_124 color;

    NbtType(byte typeId, class_124 color) {
        this.typeId = typeId;
        this.color = color;
    }

    public static NbtType fromId(byte id) {
        for (NbtType type : values()) {
            if (type.typeId == id) return type;
        }
        return END;
    }
}