package com.debugger.entity.screen;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public class DropdownWidget extends class_339 {
    private final List<Option> options;
    private int selectedIndex;
    private boolean expanded = false;
    private Consumer<Option> changeListener;
    private final class_437 parentScreen;

    public DropdownWidget(class_437 parent, int x, int y, int width, int height,
                          class_2561 message, List<Option> options, int defaultIndex) {
        super(x, y, width, height, message);
        this.parentScreen = parent;
        this.options = options;
        this.selectedIndex = defaultIndex;
    }

    public void setChangedListener(Consumer<Option> listener) {
        this.changeListener = listener;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean parentMouseClicked(double mouseX, double mouseY, int button) {
        if (expanded && !method_25405(mouseX, mouseY)) {
            expanded = false;
            return true;
        }
        return false;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) return;

        // 背景
        context.method_25294(method_46426(), method_46427(), method_46426() + field_22758, method_46427() + field_22759, 0xFF333333);

        // 边框
        context.method_25294(method_46426(), method_46427(), method_46426() + field_22758, method_46427() + 1, 0xFF666666);
        context.method_25294(method_46426(), method_46427() + field_22759 - 1, method_46426() + field_22758, method_46427() + field_22759, 0xFF666666);
        context.method_25294(method_46426(), method_46427(), method_46426() + 1, method_46427() + field_22759, 0xFF666666);
        context.method_25294(method_46426() + field_22758 - 1, method_46427(), method_46426() + field_22758, method_46427() + field_22759, 0xFF666666);

        // 当前选中的文本
        Option selected = options.get(selectedIndex);
        context.method_27535(class_310.method_1551().field_1772, selected.text(),
                method_46426() + 5, method_46427() + (field_22759 - 8) / 2, 0xFFFFFF);

        // 下拉箭头
        context.method_27535(class_310.method_1551().field_1772,
                class_2561.method_43470("▼"),
                method_46426() + field_22758 - 15, method_46427() + (field_22759 - 8) / 2,
                method_49606() ? 0xFFFFA0 : 0xFFFFFF);

        // 下拉列表
        if (expanded) {
            int dropdownHeight = options.size() * (field_22759 + 2);
            // 下拉框背景
            context.method_25294(method_46426(), method_46427() + field_22759 + 1,
                    method_46426() + field_22758, method_46427() + field_22759 + 1 + dropdownHeight, 0xFF222222);
            // 下拉框外边框
            context.method_25294(method_46426(), method_46427() + field_22759, method_46426() + field_22758, method_46427() + field_22759 + 1, 0xFF666666);
            context.method_25294(method_46426(), method_46427() + field_22759 + 1 + dropdownHeight,
                    method_46426() + field_22758, method_46427() + field_22759 + 2 + dropdownHeight, 0xFF666666);
            context.method_25294(method_46426(), method_46427() + field_22759, method_46426() + 1, method_46427() + field_22759 + 2 + dropdownHeight, 0xFF666666);
            context.method_25294(method_46426() + field_22758 - 1, method_46427() + field_22759,
                    method_46426() + field_22758, method_46427() + field_22759 + 2 + dropdownHeight, 0xFF666666);

            for (int i = 0; i < options.size(); i++) {
                int optionY = method_46427() + field_22759 + 1 + i * (field_22759 + 2);
                boolean hovered = method_25405(mouseX, mouseY) &&
                        mouseY >= optionY && mouseY < optionY + field_22759;

                // 选项背景
                context.method_25294(method_46426() + 1, optionY,
                        method_46426() + field_22758 - 1, optionY + field_22759,
                        hovered ? 0xFF444444 : 0xFF333333);

                // 选项上边线（除第一个选项外）
                if (i > 0) {
                    context.method_25294(method_46426() + 1, optionY - 1,
                            method_46426() + field_22758 - 1, optionY, 0xFF555555);
                }

                // 选项文本
                context.method_27535(class_310.method_1551().field_1772,
                        options.get(i).text(),
                        method_46426() + 5, optionY + (field_22759 - 8) / 2,
                        0xFFFFFF);
            }
        }
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {

    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22763 || !this.field_22764) return false;

        if (expanded) {
            // 检查是否点击了选项
            for (int i = 0; i < options.size(); i++) {
                int optionY = method_46427() + field_22759 + 1 + i * (field_22759 + 2);
                if (mouseY >= optionY && mouseY < optionY + field_22759) {
                    selectedIndex = i;
                    if (changeListener != null) {
                        changeListener.accept(options.get(selectedIndex));
                    }
                    expanded = false;
                    return true;
                }
            }
            // 点击外部关闭下拉
            expanded = false;
            return true;
        } else if (method_25405(mouseX, mouseY)) {
            expanded = true;
            return true;
        }
        return false;
    }

    @Override
    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.field_22764) return false;

        boolean inMainArea = mouseX >= (double)this.method_46426() &&
                mouseY >= (double)this.method_46427() &&
                mouseX < (double)(this.method_46426() + this.field_22758) &&
                mouseY < (double)(this.method_46427() + this.field_22759);

        if (expanded) {
            boolean inDropdownArea = mouseX >= (double)this.method_46426() &&
                    mouseY >= (double)this.method_46427() + this.field_22759 &&
                    mouseX < (double)(this.method_46426() + this.field_22758) &&
                    mouseY < (double)(this.method_46427() + this.field_22759 + options.size() * (field_22759 + 2));
            return inMainArea || inDropdownArea;
        }
        return inMainArea;
    }

    public static record Option(class_2561 text, class_2520 value) {}
}