package com.debugger.entity.screen;

import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class NbtListEditorWidget extends MultiLineTextFieldWidget {
    private static final int BRACKET_COLOR = 0xFF00FFFF; // 青色括号
    private static final int BRACE_COLOR = 0xFFFFFF00;   // 黄色大括号
    private static final int DEFAULT_TEXT_COLOR = 0xFFFFFFFF; // 默认文本颜色（白色）
    private static final int CURSOR_COLOR = 0xFFFFFFFF;  // 光标颜色
    private static final int SELECTION_COLOR = 0x803333FF; // 文本选择颜色

    public NbtListEditorWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 message) {
        super(textRenderer, x, y, width, height, message);
        this.textRenderer = textRenderer;
        this.method_1888(true);
    }

    @Override
    protected void renderWrappedText(class_332 context) {
        String text = this.method_1882();
        int startY = this.method_46427() + 6;
        int maxWidth = this.method_25368() - 8;

        // 分割文本为多行（按换行符）
        List<String> lines = new ArrayList<>();
        int pos = 0;
        while (pos < text.length()) {
            int lineEnd = text.indexOf('\n', pos);
            if (lineEnd == -1) lineEnd = text.length();
            String line = text.substring(pos, lineEnd);
            lines.add(line);
            pos = lineEnd + 1;
        }

        // 渲染每一行（带括号高亮）
        int yPos = startY;
        for (String line : lines) {
            int xPos = this.method_46426() + 4;
            for (int i = 0; i < line.length(); i++) {
                char c = line.charAt(i);
                String charStr = String.valueOf(c);
                int color = DEFAULT_TEXT_COLOR;

                // 高亮括号
                if (c == '[' || c == ']') {
                    color = BRACKET_COLOR;
                } else if (c == '{' || c == '}') {
                    color = BRACE_COLOR;
                }

                context.method_51433(textRenderer, charStr, xPos, yPos, color, false);
                xPos += textRenderer.method_1727(charStr);
            }
            yPos += textRenderer.field_2000;
        }

        // 渲染光标
        renderCursor(context);
    }

    private void renderCursor(class_332 context) {
        if (!this.method_25370()) return;

        String text = this.method_1882();
        int cursorPos = this.method_1881();

        // 计算光标所在行
        String textBeforeCursor = text.substring(0, cursorPos);
        String[] lines = textBeforeCursor.split("\n", -1);
        int currentLine = lines.length - 1;

        // 计算光标X位置（当前行的宽度）
        String currentLineText = lines[currentLine];
        int cursorX = this.method_46426() + 4 + textRenderer.method_1727(currentLineText);

        // 计算光标Y位置
        int cursorY = this.method_46427() + 6 + (currentLine * textRenderer.field_2000);

        // 绘制光标
        context.method_25294(cursorX, cursorY, cursorX + 1, cursorY + textRenderer.field_2000, CURSOR_COLOR);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }

        boolean clicked = mouseX >= this.method_46426() &&
                mouseX < this.method_46426() + this.field_22758 &&
                mouseY >= this.method_46427() &&
                mouseY < this.method_46427() + this.field_22759;

        if (clicked) {
            this.method_25365(true);
            this.setCursorFromMousePos(mouseX, mouseY);
            return true;
        }
        return false;
    }

    private void setCursorFromMousePos(double mouseX, double mouseY) {
        String text = this.method_1882();
        int relativeX = (int)mouseX - this.method_46426() - 4;
        int relativeY = (int)mouseY - this.method_46427() - 6;

        // 计算点击的行号
        int lineNumber = Math.max(0, relativeY / this.textRenderer.field_2000);
        String[] lines = text.split("\n", -1);

        if (lineNumber >= lines.length) {
            this.method_1883(text.length());
            return;
        }

        // 在当前行中找到点击位置
        String line = lines[lineNumber];
        int linePos = 0;
        int accumulatedWidth = 0;

        while (linePos < line.length()) {
            int charWidth = textRenderer.method_1727(line.substring(linePos, linePos + 1));
            if (accumulatedWidth + charWidth / 2 > relativeX) {
                break;
            }
            accumulatedWidth += charWidth;
            linePos++;
        }

        // 计算全局光标位置
        int globalPos = 0;
        for (int i = 0; i < lineNumber; i++) {
            globalPos += lines[i].length() + 1; // +1 for newline
        }
        globalPos += linePos;

        this.method_1883(globalPos);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case GLFW.GLFW_KEY_UP:
                moveCursorUp();
                return true;
            case GLFW.GLFW_KEY_DOWN:
                moveCursorDown();
                return true;
            case GLFW.GLFW_KEY_ENTER:
                this.method_1867("\n");
                return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void moveCursorUp() {
        int cursorPos = this.method_1881();
        String text = this.method_1882();

        if (text.isEmpty()) return;

        int lineStart = text.lastIndexOf('\n', cursorPos - 1);
        if (lineStart == -1) {
            this.method_1883(0);
            return;
        }

        int prevLineStart = text.lastIndexOf('\n', lineStart - 1);
        int lineOffset = cursorPos - lineStart - 1;

        if (prevLineStart == -1) {
            this.method_1883(Math.min(lineOffset, lineStart));
        } else {
            String prevLine = text.substring(prevLineStart + 1, lineStart);
            int newPos = prevLineStart + 1 + Math.min(lineOffset, prevLine.length());
            this.method_1883(newPos);
        }
    }

    private void moveCursorDown() {
        int cursorPos = this.method_1881();
        String text = this.method_1882();

        if (text.isEmpty()) return;

        int lineEnd = text.indexOf('\n', cursorPos);
        if (lineEnd == -1) lineEnd = text.length();

        int nextLineStart = lineEnd + 1;
        if (nextLineStart >= text.length()) {
            this.method_1883(text.length());
            return;
        }

        int nextLineEnd = text.indexOf('\n', nextLineStart);
        if (nextLineEnd == -1) nextLineEnd = text.length();

        int lineOffset = cursorPos - (text.lastIndexOf('\n', cursorPos) + 1);
        String nextLine = text.substring(nextLineStart, nextLineEnd);
        int newPos = nextLineStart + Math.min(lineOffset, nextLine.length());

        this.method_1883(newPos);
    }
}