/*
 * Decompiled with CFR 0.152.
 */
package com.debugger.entity.screen;

import com.debugger.entity.EntityDebugger;
import com.debugger.entity.screen.DropdownWidget;
import com.debugger.entity.screen.NbtListEditorWidget;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7919;

public class EntityDebugScreen
extends class_437 {
    private DropdownWidget activeDropdown;
    private static final Set<String> SPECIAL_TAGS = Set.of("Pos", "Rotation", "Motion", "Health", "Air", "Fire", "Invulnerable", "PortalCooldown", "CustomName", "NoGravity");
    private static final Map<Byte, Integer> TYPE_COLORS = Map.ofEntries(Map.entry((byte)0, -11184811), Map.entry((byte)1, -12417035), Map.entry((byte)2, -11751600), Map.entry((byte)3, -16121), Map.entry((byte)4, -6543440), Map.entry((byte)5, -1499549), Map.entry((byte)6, -769226), Map.entry((byte)7, -14575885), Map.entry((byte)8, -7617718), Map.entry((byte)9, -16728876), Map.entry((byte)10, -8825528), Map.entry((byte)11, -26624), Map.entry((byte)12, -10011977));
    private class_342 activeEditor;
    private class_4185 prevButton;
    private class_4185 nextButton;
    private String editingKey;
    private final Map<String, class_2520> nbtMap = new LinkedHashMap<String, class_2520>();
    private final List<String> nbtKeys = new ArrayList<String>();
    private int currentPage = 1;
    private int itemsPerPage;
    private final class_1297 entity;
    private byte selectedType = (byte)8;
    private final List<String> visibleKeys = new ArrayList<String>();
    private class_342 addKeyField;
    private class_342 addValueField;
    private final Map<String, class_2520> modifiedValues = new HashMap<String, class_2520>();
    private boolean hasUnsavedChanges = false;
    private static final int PANEL_COLOR = -13816531;
    private static final int HIGHLIGHT_COLOR = -12961222;
    private static final int TEXT_COLOR = -1;
    private static final int SECONDARY_TEXT_COLOR = -5592406;
    private static final int ACCENT_COLOR = -11751600;
    private static final int WARNING_COLOR = -24576;
    private static final int MARGIN = 10;
    private static final int PANEL_PADDING = 5;
    private static final int ENTRY_HEIGHT = 20;
    private static final int HEADER_HEIGHT = 45;

    public EntityDebugScreen(class_1297 entity) {
        super((class_2561)class_2561.method_43471((String)"entity_debugger.screen.title"));
        this.entity = entity;
    }

    protected void method_25426() {
        super.method_25426();
        this.calculatePageSize();
        this.createPaginationControls();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.add_nbt"), button -> this.openAddNbtDialog()).method_46434(this.field_22789 - 110, 15, 90, 24).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"entity_debugger.screen.add_nbt.tooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.save_all"), button -> {
            if (this.activeEditor != null) {
                this.saveEditedValue();
            }
            this.saveAllChanges();
        }).method_46434(this.field_22789 - 110, 45, 90, 24).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"entity_debugger.screen.save_all.tooltip"))).method_46431());
        this.reloadNbtData();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderCustomBackground(context);
        this.renderHeaderPanel(context);
        this.renderNbtEntries(context);
        this.renderPagination(context);
        if (this.activeEditor != null) {
            this.activeEditor.method_25394(context, mouseX, mouseY, delta);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderCustomBackground(class_332 context) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -872415232);
        int panelX = 10;
        int panelY = 10;
        int panelWidth = this.field_22789 - 20;
        int panelHeight = this.field_22790 - 20;
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -13816531);
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + 1, -11751600);
        context.method_25294(panelX, panelY + panelHeight - 1, panelX + panelWidth, panelY + panelHeight, -11751600);
        context.method_25294(panelX, panelY, panelX + 1, panelY + panelHeight, -11751600);
        context.method_25294(panelX + panelWidth - 1, panelY, panelX + panelWidth, panelY + panelHeight, -11751600);
    }

    private void renderHeaderPanel(class_332 context) {
        context.method_25294(15, 15, this.field_22789 - 15, 45, -12961222);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"entity_debugger.screen.title").method_27692(class_124.field_1067), this.field_22789 / 2, 25, -1);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)(this.entity.method_5477().getString() + " - " + this.entity.method_5845())).method_27692(class_124.field_1056), 25, 50, -5592406);
        if (this.hasUnsavedChanges) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"entity_debugger.screen.unsaved_changes").method_27692(class_124.field_1054), this.field_22789 - 120, 75, -24576);
        }
    }

    private void renderNbtEntries(class_332 context) {
        int i;
        int startY = 60;
        int startIdx = (this.currentPage - 1) * this.itemsPerPage;
        int endIdx = Math.min(startIdx + this.itemsPerPage, this.nbtKeys.size());
        for (i = 0; i < endIdx - startIdx; ++i) {
            int y = startY + i * 20;
            int color = i % 2 == 0 ? -13816531 : -12961222;
            context.method_25294(15, y, this.field_22789 - 10 - 5, y + 20 - 2, color);
        }
        for (i = startIdx; i < endIdx; ++i) {
            String key = this.nbtKeys.get(i);
            class_2520 value = this.nbtMap.get(key);
            int yPos = startY + (i - startIdx) * 20 + 6;
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)key).method_27692(class_124.field_1054), 20, yPos, -1, false);
            int equalsX = 20 + this.field_22793.method_1727(key) + 5;
            context.method_51433(this.field_22793, "=", equalsX, yPos, -5592406, false);
            int valueX = equalsX + 10;
            int color = TYPE_COLORS.getOrDefault(value.method_10711(), -1);
            context.method_51439(this.field_22793, this.formatNbtValue(value), valueX, yPos, color, false);
        }
    }

    private void renderPagination(class_332 context) {
        context.method_25294(20, this.field_22790 - 40, this.field_22789 - 20, this.field_22790 - 15, -12961222);
        String pageInfo = class_2561.method_43469((String)"entity_debugger.screen.page_info", (Object[])new Object[]{this.currentPage, this.getTotalPages()}).getString();
        context.method_25300(this.field_22793, pageInfo, this.field_22789 / 2, this.field_22790 - 30, -1);
    }

    private void openAddNbtDialog() {
        class_437 addNbtScreen = new class_437((class_2561)class_2561.method_43469((String)"entity_debugger.screen.add_dialog.title", (Object[])new Object[]{this.getTypeName(this.selectedType)})){
            private static final int DIALOG_WIDTH = 320;
            private static final int DIALOG_HEIGHT = 220;
            private static final int PADDING = 20;

            private int getDialogX() {
                return (this.field_22789 - 320) / 2;
            }

            private int getDialogY() {
                return (this.field_22790 - 220) / 2;
            }

            private int getTitleY() {
                return this.getDialogY() + 10;
            }

            private int getTypeButtonsY() {
                return this.getDialogY() + 40;
            }

            private int getKeyLabelY() {
                return this.getDialogY() + 75;
            }

            private int getKeyFieldY() {
                return this.getKeyLabelY() + 15;
            }

            private int getValueLabelY() {
                return this.getKeyFieldY() + 30;
            }

            private int getValueFieldY() {
                return this.getValueLabelY() + 15;
            }

            private int getButtonsY() {
                return this.getDialogY() + 220 - 30;
            }

            protected void method_25426() {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.type.byte"), b -> this.updateType((byte)1)).method_46434(this.getDialogX() + 20, this.getTypeButtonsY() - 5, 80, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.type.int"), b -> this.updateType((byte)3)).method_46434(this.getDialogX() + 20 + 100, this.getTypeButtonsY() - 5, 80, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.type.float"), b -> this.updateType((byte)5)).method_46434(this.getDialogX() + 20 + 200, this.getTypeButtonsY() - 5, 80, 20).method_46431());
                EntityDebugScreen.this.addKeyField = new class_342(this.field_22793, this.getDialogX() + 20, this.getKeyFieldY(), 280, 20, (class_2561)class_2561.method_43473());
                EntityDebugScreen.this.addKeyField.method_47404((class_2561)class_2561.method_43471((String)"entity_debugger.screen.add_dialog.key_placeholder"));
                this.method_37063((class_364)EntityDebugScreen.this.addKeyField);
                EntityDebugScreen.this.addValueField = new class_342(this.field_22793, this.getDialogX() + 20, this.getValueFieldY(), 280, 20, (class_2561)class_2561.method_43473());
                this.updateValueHint();
                this.method_37063((class_364)EntityDebugScreen.this.addValueField);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.add_dialog.cancel"), b -> this.method_25419()).method_46434(this.getDialogX() + 20, this.getButtonsY(), 120, 24).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.add_dialog.confirm"), b -> this.trySubmit()).method_46434(this.getDialogX() + 320 - 20 - 120, this.getButtonsY(), 120, 24).method_46431());
            }

            public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                this.method_25420(context);
                context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
                int x = this.getDialogX();
                int y = this.getDialogY();
                context.method_25294(x, y, x + 320, y + 220, -14540254);
                context.method_25294(x, y, x + 320, y + 30, -13421773);
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"entity_debugger.screen.add_dialog.title", (Object[])new Object[]{this.getTypeName(EntityDebugScreen.this.selectedType)}), x + 160, this.getTitleY(), 0xFFFFFF);
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"entity_debugger.screen.add_dialog.key"), x + 20, this.getKeyLabelY(), 0xAAAAAA, false);
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"entity_debugger.screen.add_dialog.value"), x + 20, this.getValueLabelY(), 0xAAAAAA, false);
                super.method_25394(context, mouseX, mouseY, delta);
            }

            private void trySubmit() {
                if (this.validateInput()) {
                    EntityDebugScreen.this.addNewNbtEntry(EntityDebugScreen.this.addKeyField.method_1882(), EntityDebugScreen.this.addValueField.method_1882());
                    this.method_25419();
                }
            }

            private boolean validateInput() {
                if (EntityDebugScreen.this.addKeyField.method_1882().isEmpty()) {
                    EntityDebugScreen.this.addKeyField.method_25355((class_2561)class_2561.method_43471((String)"entity_debugger.message.key_empty").method_27692(class_124.field_1061));
                    return false;
                }
                try {
                    switch (EntityDebugScreen.this.selectedType) {
                        case 1: {
                            if (EntityDebugScreen.this.addValueField.method_1882().equalsIgnoreCase("true") || EntityDebugScreen.this.addValueField.method_1882().equalsIgnoreCase("false")) {
                                return true;
                            }
                            Byte.parseByte(EntityDebugScreen.this.addValueField.method_1882());
                            break;
                        }
                        case 3: {
                            Integer.parseInt(EntityDebugScreen.this.addValueField.method_1882());
                            break;
                        }
                        case 5: {
                            Float.parseFloat(EntityDebugScreen.this.addValueField.method_1882());
                        }
                    }
                }
                catch (NumberFormatException e) {
                    EntityDebugScreen.this.addValueField.method_25355((class_2561)class_2561.method_43469((String)"entity_debugger.message.invalid_value", (Object[])new Object[]{this.getTypeName(EntityDebugScreen.this.selectedType)}).method_27692(class_124.field_1061));
                    return false;
                }
                return true;
            }

            private void updateType(byte type) {
                EntityDebugScreen.this.selectedType = type;
                this.updateValueHint();
            }

            private void updateValueHint() {
                String hint = class_2561.method_43471((String)("entity_debugger.screen.add_dialog.value_hint." + EntityDebugScreen.this.selectedType)).getString();
                EntityDebugScreen.this.addValueField.method_47404((class_2561)class_2561.method_43470((String)hint));
            }

            private String getTypeName(byte nbtType) {
                return class_2561.method_43469((String)("nbt.type." + (switch (nbtType) {
                    case 1 -> "byte";
                    case 3 -> "int";
                    case 5 -> "float";
                    default -> "unknown";
                })), (Object[])new Object[]{nbtType}).getString();
            }
        };
        if (this.field_22787 != null) {
            this.field_22787.method_1507(addNbtScreen);
        }
    }

    private void openListEditor(final class_2499 list, final String key) {
        final class_2499 workingCopy = list.method_10612();
        this.field_22787.method_1507(new class_437((class_2561)class_2561.method_43469((String)"entity_debugger.screen.list_editor.title", (Object[])new Object[]{key, list.size()})){
            private NbtListEditorWidget editor;
            private class_4185 formatToggle;
            private boolean prettyFormat;
            {
                super(title);
                this.prettyFormat = true;
            }

            protected void method_25426() {
                super.method_25426();
                this.formatToggle = class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.prettyFormat ? "entity_debugger.screen.list_editor.raw_format" : "entity_debugger.screen.list_editor.pretty_format")), button -> {
                    this.prettyFormat = !this.prettyFormat;
                    this.formatToggle.method_25355((class_2561)class_2561.method_43471((String)(this.prettyFormat ? "entity_debugger.screen.list_editor.raw_format" : "entity_debugger.screen.list_editor.pretty_format")));
                    this.updateEditorContent();
                }).method_46434(this.field_22789 - 120, 10, 100, 20).method_46431();
                this.method_37063((class_364)this.formatToggle);
                this.editor = new NbtListEditorWidget(this.field_22793, 20, 40, this.field_22789 - 40, this.field_22790 - 100, (class_2561)class_2561.method_43470((String)"\u7f16\u8f91NBT\u5217\u8868\u5185\u5bb9"));
                this.editor.method_1880(Integer.MAX_VALUE);
                this.updateEditorContent();
                this.method_37063((class_364)this.editor);
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.list_editor.cancel"), button -> this.returnToMainScreen()).method_46434(this.field_22789 / 2 - 105, this.field_22790 - 50, 100, 20).method_46431());
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.list_editor.save"), button -> {
                    try {
                        class_2520 parsed = EntityDebugScreen.this.parseInputValue(this.editor.method_1882(), (byte)9);
                        if (parsed instanceof class_2499) {
                            workingCopy.clear();
                            workingCopy.addAll((Collection)((class_2499)parsed));
                            this.returnToMainScreen();
                        }
                    }
                    catch (Exception e) {
                        EntityDebugScreen.this.showError(class_2561.method_43469((String)"entity_debugger.message.parse_error", (Object[])new Object[]{e.getMessage()}).getString());
                    }
                }).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 50, 100, 20).method_46431());
            }

            public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
                context.method_25294(10, 10, this.field_22789 - 10, this.field_22790 - 10, -13816531);
                context.method_25294(10, 10, this.field_22789 - 10, 40, -12961222);
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"entity_debugger.screen.list_editor.title", (Object[])new Object[]{key, list.size()}), this.field_22789 / 2, 20, -1);
                context.method_25294(20, 40, this.field_22789 - 20, this.field_22790 - 60, -14803426);
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"entity_debugger.screen.list_editor.help"), 20, this.field_22790 - 30, -5592406, false);
                super.method_25394(context, mouseX, mouseY, delta);
            }

            private void updateEditorContent() {
                if (this.prettyFormat) {
                    this.editor.method_1852(this.formatNbtListPretty(workingCopy));
                } else {
                    this.editor.method_1852(workingCopy.method_10714());
                }
            }

            private void returnToMainScreen() {
                if (!workingCopy.equals((Object)list)) {
                    EntityDebugScreen.this.modifiedValues.put(key, (class_2520)workingCopy.method_10612());
                    EntityDebugScreen.this.hasUnsavedChanges = true;
                    EntityDebugScreen.this.showSuccess(class_2561.method_43471((String)"entity_debugger.message.list_changes_staged").getString());
                }
                this.field_22787.method_1507((class_437)EntityDebugScreen.this);
            }

            public void method_25419() {
                this.returnToMainScreen();
            }

            private String formatNbtListPretty(class_2499 list2) {
                StringBuilder sb = new StringBuilder("[\n");
                for (int i = 0; i < list2.size(); ++i) {
                    sb.append("  ").append(this.formatNbtElementPretty(list2.method_10534(i), 1));
                    if (i < list2.size() - 1) {
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                return sb.append("]").toString();
            }

            private String formatNbtElementPretty(class_2520 element, int indent) {
                String indentStr = "  ".repeat(indent);
                if (element instanceof class_2487) {
                    class_2487 compound = (class_2487)element;
                    StringBuilder sb = new StringBuilder("{\n");
                    int i = 0;
                    for (String key2 : compound.method_10541()) {
                        sb.append(indentStr).append("  ").append(key2).append(": ").append(this.formatNbtElementPretty(compound.method_10580(key2), indent + 1));
                        if (++i < compound.method_10546()) {
                            sb.append(",");
                        }
                        sb.append("\n");
                    }
                    return sb.append(indentStr).append("}").toString();
                }
                if (element instanceof class_2499) {
                    class_2499 list2 = (class_2499)element;
                    StringBuilder sb = new StringBuilder("[\n");
                    for (int i = 0; i < list2.size(); ++i) {
                        sb.append(indentStr).append("  ").append(this.formatNbtElementPretty(list2.method_10534(i), indent + 1));
                        if (i < list2.size() - 1) {
                            sb.append(",");
                        }
                        sb.append("\n");
                    }
                    return sb.append(indentStr).append("]").toString();
                }
                return element.method_10714();
            }
        });
    }

    private void addNewNbtEntry(String key, String value) {
        if (key.isEmpty()) {
            this.showError(class_2561.method_43471((String)"entity_debugger.message.key_empty").getString());
            return;
        }
        if (this.nbtMap.containsKey(key)) {
            this.showError(class_2561.method_43469((String)"entity_debugger.message.key_exists", (Object[])new Object[]{key}).getString());
            return;
        }
        try {
            class_2520 newValue = this.createNbtElement(value, this.selectedType);
            this.nbtMap.put(key, newValue);
            this.nbtKeys.add(key);
            this.modifiedValues.put(key, newValue);
            this.hasUnsavedChanges = true;
            this.updateVisibleItems();
            this.showSuccess(class_2561.method_43469((String)"entity_debugger.message.add_success", (Object[])new Object[]{key}).getString());
        }
        catch (InvalidNbtFormatException e) {
            this.showError(e.getMessage());
        }
    }

    private class_2520 createNbtElement(String value, byte type) throws InvalidNbtFormatException {
        value = ((String)value).trim();
        try {
            switch (type) {
                case 1: {
                    if (((String)value).equalsIgnoreCase("true")) {
                        return class_2481.field_21027;
                    }
                    if (((String)value).equalsIgnoreCase("false")) {
                        return class_2481.field_21026;
                    }
                    return class_2481.method_23233((byte)Byte.parseByte((String)value));
                }
                case 2: {
                    if (((String)value).endsWith("s") || ((String)value).endsWith("S")) {
                        value = ((String)value).substring(0, ((String)value).length() - 1);
                    }
                    return class_2516.method_23254((short)Short.parseShort((String)value));
                }
                case 3: {
                    return class_2497.method_23247((int)Integer.parseInt((String)value));
                }
                case 4: {
                    if (((String)value).endsWith("L") || ((String)value).endsWith("l")) {
                        value = ((String)value).substring(0, ((String)value).length() - 1);
                    }
                    return class_2503.method_23251((long)Long.parseLong((String)value));
                }
                case 5: {
                    if (((String)value).endsWith("F") || ((String)value).endsWith("f")) {
                        value = ((String)value).substring(0, ((String)value).length() - 1);
                    }
                    return class_2494.method_23244((float)Float.parseFloat((String)value));
                }
                case 6: {
                    return class_2489.method_23241((double)Double.parseDouble((String)value));
                }
                case 8: {
                    return class_2519.method_23256((String)value);
                }
                case 7: {
                    if (!((String)value).startsWith("[B;")) {
                        value = "[B;" + (String)value;
                    }
                    if (!((String)value).endsWith("]")) {
                        value = (String)value + "]";
                    }
                    return class_2522.method_10718((String)value);
                }
                case 11: {
                    if (!((String)value).startsWith("[I;")) {
                        value = "[I;" + (String)value;
                    }
                    if (!((String)value).endsWith("]")) {
                        value = (String)value + "]";
                    }
                    return class_2522.method_10718((String)value);
                }
                case 12: {
                    if (!((String)value).startsWith("[L;")) {
                        value = "[L;" + (String)value;
                    }
                    if (!((String)value).endsWith("]")) {
                        value = (String)value + "]";
                    }
                    return class_2522.method_10718((String)value);
                }
                case 9: {
                    value = ((String)value).trim();
                    if (!((String)value).startsWith("[")) {
                        value = "[" + (String)value;
                    }
                    if (!((String)value).endsWith("]")) {
                        value = (String)value + "]";
                    }
                    if (!(((String)(value = ((String)value).replaceAll("([0-9\\.]+)[fF]([,}\\]])", "$1$2"))).startsWith("[I;") || ((String)value).startsWith("[B;") || ((String)value).startsWith("[L;") || ((String)value).startsWith("[{") || ((String)value).startsWith("[\""))) {
                        value = "[I;" + ((String)value).substring(1);
                    }
                    return class_2522.method_10718((String)value);
                }
                case 10: {
                    if (!((String)value).startsWith("{")) {
                        value = "{" + (String)value;
                    }
                    if (!((String)value).endsWith("}")) {
                        value = (String)value + "}";
                    }
                    return class_2522.method_10718((String)value);
                }
            }
            throw new InvalidNbtFormatException("\u4e0d\u652f\u6301\u7684NBT\u7c7b\u578b: " + this.getTypeName(type));
        }
        catch (Exception e) {
            throw new InvalidNbtFormatException(this.getTypeName(type) + "\u7c7b\u578b\u89e3\u6790\u5931\u8d25: " + e.getMessage());
        }
    }

    private class_2520 parseNbtList(String input) throws Exception {
        if (!((String)(input = ((String)input).trim())).startsWith("[")) {
            input = "[" + (String)input;
        }
        if (!((String)input).endsWith("]")) {
            input = (String)input + "]";
        }
        if (((String)input).equals("[]")) {
            return new class_2499();
        }
        if (((String)input).startsWith("[I;") || ((String)input).startsWith("[B;") || ((String)input).startsWith("[L;") || ((String)input).startsWith("[D;") || ((String)input).startsWith("[F;") || ((String)input).startsWith("[{") || ((String)input).startsWith("[\"")) {
            return class_2522.method_10718((String)input);
        }
        return this.parseUniversalList((String)input);
    }

    private class_2520 parseUniversalList(String input) throws Exception {
        String content = input.substring(1, input.length() - 1).trim();
        if (content.isEmpty()) {
            return new class_2499();
        }
        class_2499 result = new class_2499();
        int braceLevel = 0;
        int bracketLevel = 0;
        StringBuilder currentElement = new StringBuilder();
        for (int position = 0; position < content.length(); ++position) {
            char c = content.charAt(position);
            if (c == '{') {
                ++braceLevel;
            }
            if (c == '}') {
                --braceLevel;
            }
            if (c == '[') {
                ++bracketLevel;
            }
            if (c == ']') {
                --bracketLevel;
            }
            if (c == ',' && braceLevel == 0 && bracketLevel == 0) {
                this.addUniversalElement(result, currentElement.toString().trim());
                currentElement = new StringBuilder();
                continue;
            }
            currentElement.append(c);
        }
        if (currentElement.length() > 0) {
            this.addUniversalElement(result, currentElement.toString().trim());
        }
        return result;
    }

    private void addUniversalElement(class_2499 list, String element) throws Exception {
        block15: {
            if (element.isEmpty()) {
                return;
            }
            try {
                if (element.startsWith("[")) {
                    list.add((Object)this.parseNbtList(element));
                    return;
                }
                if (element.startsWith("{")) {
                    list.add((Object)class_2522.method_10718((String)element));
                    return;
                }
                if (element.equalsIgnoreCase("true")) {
                    list.add((Object)class_2481.field_21027);
                    break block15;
                }
                if (element.equalsIgnoreCase("false")) {
                    list.add((Object)class_2481.field_21026);
                    break block15;
                }
                if (element.matches("^-?\\d+[bB]$")) {
                    list.add((Object)class_2481.method_23233((byte)Byte.parseByte(element.substring(0, element.length() - 1))));
                    break block15;
                }
                if (element.matches("^-?\\d+[sS]$")) {
                    list.add((Object)class_2516.method_23254((short)Short.parseShort(element.substring(0, element.length() - 1))));
                    break block15;
                }
                if (element.matches("^-?\\d+[lL]$")) {
                    list.add((Object)class_2503.method_23251((long)Long.parseLong(element.substring(0, element.length() - 1))));
                    break block15;
                }
                if (element.matches("^-?\\d+\\.\\d+([dD]|([eE][-+]?\\d+))?$")) {
                    list.add((Object)class_2489.method_23241((double)Double.parseDouble(element.replaceAll("[dD]$", ""))));
                    break block15;
                }
                if (element.matches("^-?\\d+\\.?\\d*[fF]$")) {
                    list.add((Object)class_2494.method_23244((float)Float.parseFloat(element.substring(0, element.length() - 1))));
                    break block15;
                }
                if (element.matches("^-?\\d+$")) {
                    list.add((Object)class_2497.method_23247((int)Integer.parseInt(element)));
                    break block15;
                }
                if (element.matches("^-?\\d+\\.\\d+$")) {
                    list.add((Object)class_2489.method_23241((double)Double.parseDouble(element)));
                    break block15;
                }
                if (element.startsWith("\"") && element.endsWith("\"")) {
                    list.add((Object)class_2519.method_23256((String)element.substring(1, element.length() - 1)));
                    break block15;
                }
                throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u5217\u8868\u5143\u7d20: " + element);
            }
            catch (NumberFormatException e) {
                throw new Exception("\u6570\u5b57\u683c\u5f0f\u9519\u8bef: " + element);
            }
        }
    }

    private void createPaginationControls() {
        int buttonWidth = 30;
        int buttonHeight = 20;
        int spacing = 10;
        int totalWidth = buttonWidth * 2 + spacing + this.field_22793.method_1727("\u7b2c1/1\u9875");
        int startX = (this.field_22789 - totalWidth) / 2;
        int buttonY = this.field_22790 - 37;
        this.prevButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.previous_page"), btn -> {
            this.cleanupEditing();
            this.currentPage = Math.max(1, this.currentPage - 1);
            this.updateVisibleItems();
        }).method_46434(startX, buttonY, buttonWidth, buttonHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"entity_debugger.screen.previous_page.tooltip"))).method_46431();
        int textX = startX + buttonWidth + spacing / 2;
        this.nextButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"entity_debugger.screen.next_page"), btn -> {
            this.cleanupEditing();
            this.currentPage = Math.min(this.getTotalPages(), this.currentPage + 1);
            this.updateVisibleItems();
        }).method_46434(textX + this.field_22793.method_1727(class_2561.method_43469((String)"entity_debugger.screen.page_info", (Object[])new Object[]{1, 1}).getString()) + spacing / 2, buttonY, buttonWidth, buttonHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"entity_debugger.screen.next_page.tooltip"))).method_46431();
        this.method_37063((class_364)this.prevButton);
        this.method_37063((class_364)this.nextButton);
    }

    private void updateButtonStates() {
        if (this.prevButton != null && this.nextButton != null) {
            this.prevButton.field_22763 = this.currentPage > 1;
            this.nextButton.field_22763 = this.currentPage < this.getTotalPages();
        }
    }

    private void updateVisibleItems() {
        this.nbtKeys.sort(String::compareToIgnoreCase);
        int start = (this.currentPage - 1) * this.itemsPerPage;
        int end = Math.min(start + this.itemsPerPage, this.nbtKeys.size());
        this.visibleKeys.clear();
        for (int i = start; i < end; ++i) {
            this.visibleKeys.add(this.nbtKeys.get(i));
        }
        this.updateButtonStates();
    }

    private void reloadNbtData() {
        class_2487 nbt = this.entity.method_5647(new class_2487());
        this.nbtMap.clear();
        this.nbtKeys.clear();
        nbt.method_10541().stream().sorted(Comparator.comparing(key -> {
            if (key.equals("id")) {
                return 0;
            }
            if (key.equals("Pos")) {
                return 1;
            }
            if (key.equals("Rotation")) {
                return 2;
            }
            return 3;
        })).forEach(key -> {
            this.nbtMap.put((String)key, nbt.method_10580(key));
            this.nbtKeys.add((String)key);
        });
        this.calculatePageSize();
        this.updateVisibleItems();
    }

    private void calculatePageSize() {
        this.itemsPerPage = Math.max(1, (this.field_22790 - 80) / 20 - 1);
    }

    private class_2561 formatNbtValue(class_2520 value) {
        class_124 color = class_124.method_534((int)TYPE_COLORS.getOrDefault(value.method_10711(), -1));
        Object text = switch (value.method_10711()) {
            case 8 -> "\"" + value.method_10714() + "\"";
            case 10 -> "{...}";
            case 9 -> "List[" + ((class_2499)value).size() + "]";
            case 7 -> "ByteArray[" + ((class_2479)value).method_10521().length + "]";
            case 11 -> "IntArray[" + ((class_2495)value).method_10588().length + "]";
            case 12 -> "LongArray[" + ((class_2501)value).method_10615().length + "]";
            case 1 -> {
                if (value.equals((Object)class_2481.field_21027)) {
                    yield "true";
                }
                if (value.equals((Object)class_2481.field_21026)) {
                    yield "false";
                }
                yield value.method_10714();
            }
            case 2 -> value.method_10714();
            case 5 -> value.method_10714();
            case 4 -> value.method_10714();
            default -> value.method_10714();
        };
        return class_2561.method_43470((String)text).method_27692(color);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int clickedIndex;
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.activeDropdown != null && this.activeDropdown.parentMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)(this.field_22789 - 110) && mouseX <= (double)(this.field_22789 - 20) && mouseY >= 15.0 && mouseY <= 69.0) {
            return false;
        }
        int startY = 60;
        int endY = startY + this.itemsPerPage * 20;
        if (mouseY >= (double)startY && mouseY <= (double)endY && mouseX >= 15.0 && mouseX <= (double)(this.field_22789 - 10 - 5) && (clickedIndex = (int)((mouseY - (double)startY) / 20.0)) >= 0 && clickedIndex < this.itemsPerPage) {
            this.startEditing(clickedIndex);
            return true;
        }
        if (button == 0 && this.activeEditor != null && !this.activeEditor.method_25405(mouseX, mouseY)) {
            this.saveEditedValue();
            return true;
        }
        if (mouseY >= (double)(this.field_22790 - 40) && mouseY <= (double)(this.field_22790 - 15)) {
            return false;
        }
        return false;
    }

    private boolean isMouseOverEditor(double mouseX, double mouseY) {
        if (this.activeEditor != null && this.activeEditor.method_25405(mouseX, mouseY)) {
            return true;
        }
        if (this.activeDropdown != null && this.activeDropdown.method_25405(mouseX, mouseY)) {
            return true;
        }
        if (mouseX >= (double)(this.field_22789 - 100) && mouseX <= (double)(this.field_22789 - 20) && mouseY >= 45.0 && mouseY <= 65.0) {
            return true;
        }
        for (class_364 child : this.method_25396()) {
            class_339 widget;
            if (!(child instanceof class_339) || !(widget = (class_339)child).method_25405(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public void clearActiveEditors() {
        if (this.activeEditor != null) {
            this.method_37066((class_364)this.activeEditor);
            this.activeEditor = null;
        }
        this.editingKey = null;
        this.method_25395(null);
    }

    private int getClickedIndex(double mouseX, double mouseY) {
        int startY = 60;
        int entryHeight = 20;
        if (mouseX < 20.0 || mouseX > (double)(this.field_22789 - 20) || mouseY < (double)startY || mouseY > (double)(startY + this.itemsPerPage * entryHeight)) {
            return -1;
        }
        int relativeY = (int)(mouseY - (double)startY);
        int index = relativeY / entryHeight;
        int startIdx = (this.currentPage - 1) * this.itemsPerPage;
        if (index >= 0 && startIdx + index < this.nbtKeys.size()) {
            return index;
        }
        return -1;
    }

    private void startEditing(int relativeIndex) {
        this.clearActiveEditors();
        int absoluteIndex = (this.currentPage - 1) * this.itemsPerPage + relativeIndex;
        if (absoluteIndex >= this.nbtKeys.size()) {
            return;
        }
        this.editingKey = this.nbtKeys.get(absoluteIndex);
        class_2520 value = this.nbtMap.get(this.editingKey);
        if (value instanceof class_2499) {
            this.openListEditor((class_2499)value, this.editingKey);
            return;
        }
        int startY = 60;
        int yPos = startY + relativeIndex * 20;
        int keyWidth = this.field_22793.method_1727(this.editingKey) + 15;
        int editorX = 20 + keyWidth;
        int editorWidth = this.field_22789 - editorX - 10 - 5 - 20;
        if (editorWidth < 100) {
            editorWidth = 100;
        }
        if (value.method_10711() == 1 && (value.equals((Object)class_2481.field_21027) || value.equals((Object)class_2481.field_21026))) {
            DropdownWidget dropdown = new DropdownWidget(this, editorX, yPos, editorWidth, 18, (class_2561)class_2561.method_43471((String)"entity_debugger.screen.boolean_dropdown"), List.of(new DropdownWidget.Option((class_2561)class_2561.method_43471((String)"entity_debugger.screen.true"), (class_2520)class_2481.field_21027), new DropdownWidget.Option((class_2561)class_2561.method_43471((String)"entity_debugger.screen.false"), (class_2520)class_2481.field_21026)), value.equals((Object)class_2481.field_21027) ? 0 : 1);
            dropdown.setChangedListener(selected -> {
                this.modifiedValues.put(this.editingKey, selected.value());
                this.hasUnsavedChanges = true;
                this.syncToEntity(this.editingKey, selected.value());
                this.activeDropdown = null;
                this.clearActiveEditors();
                this.showSuccess(class_2561.method_43469((String)"entity_debugger.message.boolean_updated", (Object[])new Object[]{this.editingKey}).getString());
            });
            this.method_37063((class_364)dropdown);
            this.method_25395((class_364)dropdown);
            this.activeDropdown = dropdown;
            return;
        }
        this.activeEditor = new class_342(this.field_22793, editorX, yPos, editorWidth, 18, (class_2561)class_2561.method_43469((String)"entity_debugger.screen.edit", (Object[])new Object[]{this.editingKey}));
        this.activeEditor.method_1852(value.method_10714());
        this.activeEditor.method_1863(this::validateInput);
        this.method_25429((class_364)this.activeEditor);
        this.method_25395((class_364)this.activeEditor);
    }

    private void validateInput(String text) {
        block5: {
            if (this.activeEditor == null || this.editingKey == null) {
                return;
            }
            try {
                class_2520 original = this.nbtMap.get(this.editingKey);
                if (original == null) {
                    return;
                }
                byte expectedType = original.method_10711();
                if (expectedType == 1 && (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("false"))) {
                    this.activeEditor.method_1868(0xFFFFFF);
                    return;
                }
                this.parseInputValue(text, expectedType);
                this.activeEditor.method_1868(0xFFFFFF);
            }
            catch (Exception e) {
                if (this.activeEditor == null) break block5;
                this.activeEditor.method_1868(0xFF5555);
            }
        }
    }

    private void saveAllChanges() {
        if (!this.hasUnsavedChanges || this.modifiedValues.isEmpty()) {
            this.showError(class_2561.method_43471((String)"entity_debugger.message.no_changes").getString());
            return;
        }
        try {
            class_2487 entityNbt = this.entity.method_5647(new class_2487());
            for (Map.Entry<String, class_2520> entry : this.modifiedValues.entrySet()) {
                String key = entry.getKey();
                class_2520 value = entry.getValue().method_10707();
                entityNbt.method_10566(key, value);
                EntityDebugger.LOGGER.info("\u4fdd\u5b58\u952e {}: {}", (Object)key, (Object)value.method_10714());
            }
            this.entity.method_5651(entityNbt);
            for (Map.Entry<String, class_2520> entry : this.modifiedValues.entrySet()) {
                this.syncToEntity(entry.getKey(), entry.getValue());
            }
            this.showSuccess(class_2561.method_43469((String)"entity_debugger.message.save_all_success", (Object[])new Object[]{this.modifiedValues.size()}).getString());
            this.modifiedValues.clear();
            this.hasUnsavedChanges = false;
            this.reloadNbtData();
        }
        catch (Exception e) {
            EntityDebugger.LOGGER.error("\u4fdd\u5b58\u6240\u6709\u66f4\u6539\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            this.showError("\u4fdd\u5b58\u5931\u8d25: " + e.getMessage());
        }
    }

    private void syncToEntity(String key, class_2520 value) {
        try {
            switch (key) {
                case "Pos": {
                    class_2499 list;
                    if (value instanceof class_2499 && (list = (class_2499)value).size() >= 3) {
                        double x = list.method_10611(0);
                        double y = list.method_10611(1);
                        double z = list.method_10611(2);
                        this.entity.method_30634(x, y, z);
                        this.entity.method_23327(x, y, z);
                    }
                    break;
                }
                case "Rotation": {
                    class_2499 list;
                    if (value instanceof class_2499 && (list = (class_2499)value).size() >= 2) {
                        float yaw = list.method_10604(0);
                        float pitch = list.method_10604(1);
                        this.entity.method_36456(yaw);
                        this.entity.method_36457(pitch);
                        class_1297 class_12972 = this.entity;
                        if (class_12972 instanceof class_1309) {
                            class_1309 living = (class_1309)class_12972;
                            living.method_5847(yaw);
                            living.field_6283 = yaw;
                        }
                    }
                    break;
                }
                case "Health": {
                    class_1297 yaw = this.entity;
                    if (yaw instanceof class_1309) {
                        class_2499 list;
                        class_1309 living = (class_1309)yaw;
                        if (value instanceof class_2494) {
                            class_2494 health = (class_2494)value;
                            living.method_6033(health.method_10700());
                            break;
                        }
                        if (value instanceof class_2499 && !(list = (class_2499)value).isEmpty()) {
                            living.method_6033(list.method_10604(0));
                        }
                    }
                    break;
                }
                case "Motion": {
                    class_2499 list;
                    if (value instanceof class_2499 && (list = (class_2499)value).size() >= 3) {
                        double mx = list.method_10611(0);
                        double my = list.method_10611(1);
                        double mz = list.method_10611(2);
                        this.entity.method_18800(mx, my, mz);
                    }
                    break;
                }
                case "Air": {
                    class_1297 mx = this.entity;
                    if (mx instanceof class_1309) {
                        class_1309 living = (class_1309)mx;
                        if (value instanceof class_2516) {
                            class_2516 air = (class_2516)value;
                            living.method_5855((int)air.method_10696());
                        }
                    }
                    break;
                }
                case "Fire": {
                    int n;
                    if (value instanceof class_2516) {
                        class_2516 fire = (class_2516)value;
                        n = fire.method_10696();
                    } else {
                        n = 0;
                    }
                    this.entity.method_20803(n);
                    break;
                }
                case "Invulnerable": {
                    class_2481 invul;
                    this.entity.method_5684(value instanceof class_2481 && (invul = (class_2481)value).method_10698() != 0);
                    break;
                }
                case "PortalCooldown": {
                    int n;
                    if (value instanceof class_2497) {
                        class_2497 cooldown = (class_2497)value;
                        n = cooldown.method_10701();
                    } else {
                        n = 0;
                    }
                    this.entity.method_51850(n);
                    break;
                }
                case "CustomName": {
                    if (value instanceof class_2519) {
                        class_2519 name = (class_2519)value;
                        this.entity.method_5665((class_2561)class_2561.method_43470((String)name.method_10714()));
                    }
                    break;
                }
                case "NoGravity": {
                    class_2481 noGrav;
                    this.entity.method_5875(value instanceof class_2481 && (noGrav = (class_2481)value).method_10698() != 0);
                }
            }
        }
        catch (Exception e) {
            EntityDebugger.LOGGER.error("\u540c\u6b65{}\u5230\u5b9e\u4f53\u5931\u8d25: {}", (Object)key, (Object)e.getMessage());
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.calculatePageSize();
        this.method_25423(client, width, height);
        if (this.activeEditor != null) {
            int relativeIndex = this.nbtKeys.indexOf(this.editingKey) % this.itemsPerPage;
            this.cleanupEditing();
            this.startEditing(relativeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEditedValue() {
        try {
            if (this.editingKey == null || this.activeEditor == null) {
                EntityDebugger.LOGGER.warn("\u4fdd\u5b58\u5931\u8d25: \u6ca1\u6709\u6d3b\u52a8\u7684\u7f16\u8f91\u5668");
                return;
            }
            String input = this.activeEditor.method_1882().trim();
            EntityDebugger.LOGGER.info("\u5c1d\u8bd5\u4fdd\u5b58\u952e {}: {}", (Object)this.editingKey, (Object)input);
            class_2520 original = this.nbtMap.get(this.editingKey);
            if (original == null) {
                EntityDebugger.LOGGER.warn("\u539f\u59cbNBT\u5143\u7d20\u4e0d\u5b58\u5728: {}", (Object)this.editingKey);
                return;
            }
            if (original.method_10711() == 1) {
                if (input.equalsIgnoreCase("true")) {
                    this.modifiedValues.put(this.editingKey, (class_2520)class_2481.field_21027);
                    this.nbtMap.put(this.editingKey, (class_2520)class_2481.field_21027);
                    this.hasUnsavedChanges = true;
                    this.syncToEntity(this.editingKey, (class_2520)class_2481.field_21027);
                    this.showSuccess(class_2561.method_43469((String)"entity_debugger.message.save_success", (Object[])new Object[]{this.editingKey}).getString());
                    this.cleanupEditing();
                    return;
                }
                if (input.equalsIgnoreCase("false")) {
                    this.modifiedValues.put(this.editingKey, (class_2520)class_2481.field_21026);
                    this.nbtMap.put(this.editingKey, (class_2520)class_2481.field_21026);
                    this.hasUnsavedChanges = true;
                    this.syncToEntity(this.editingKey, (class_2520)class_2481.field_21026);
                    this.showSuccess(class_2561.method_43469((String)"entity_debugger.message.save_success", (Object[])new Object[]{this.editingKey}).getString());
                    this.cleanupEditing();
                    return;
                }
            }
            class_2520 newValue = this.parseInputValue(input, original.method_10711());
            EntityDebugger.LOGGER.info("\u89e3\u6790\u6210\u529f: {}", (Object)newValue.method_10714());
            this.modifiedValues.put(this.editingKey, newValue);
            this.nbtMap.put(this.editingKey, newValue);
            this.hasUnsavedChanges = true;
            this.syncToEntity(this.editingKey, newValue);
            this.showSuccess(class_2561.method_43469((String)"entity_debugger.message.save_success", (Object[])new Object[]{this.editingKey}).getString());
        }
        catch (Exception e) {
            EntityDebugger.LOGGER.error("\u4fdd\u5b58\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            this.showError("\u4fdd\u5b58\u5931\u8d25: " + e.getMessage());
        }
        finally {
            this.cleanupEditing();
        }
    }

    private class_2520 parseInputValue(String input, byte expectedType) throws Exception {
        input = ((String)input).trim();
        try {
            if (((String)input).isEmpty()) {
                throw new Exception("\u8f93\u5165\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (expectedType == 1) {
                if (((String)input).equalsIgnoreCase("true") || ((String)input).equals("1")) {
                    return class_2481.field_21027;
                }
                if (((String)input).equalsIgnoreCase("false") || ((String)input).equals("0")) {
                    return class_2481.field_21026;
                }
            }
            switch (expectedType) {
                case 1: {
                    if (((String)input).endsWith("b") || ((String)input).endsWith("B")) {
                        input = ((String)input).substring(0, ((String)input).length() - 1);
                    }
                    return class_2481.method_23233((byte)Byte.parseByte((String)input));
                }
                case 2: {
                    if (((String)input).endsWith("s") || ((String)input).endsWith("S")) {
                        input = ((String)input).substring(0, ((String)input).length() - 1);
                    }
                    return class_2516.method_23254((short)Short.parseShort((String)input));
                }
                case 3: {
                    return class_2497.method_23247((int)Integer.parseInt((String)input));
                }
                case 4: {
                    if (((String)input).endsWith("l") || ((String)input).endsWith("L")) {
                        input = ((String)input).substring(0, ((String)input).length() - 1);
                    }
                    return class_2503.method_23251((long)Long.parseLong((String)input));
                }
                case 5: {
                    if (((String)input).endsWith("f") || ((String)input).endsWith("F")) {
                        input = ((String)input).substring(0, ((String)input).length() - 1);
                    }
                    return class_2494.method_23244((float)Float.parseFloat((String)input));
                }
                case 6: {
                    if (((String)input).endsWith("d") || ((String)input).endsWith("D")) {
                        input = ((String)input).substring(0, ((String)input).length() - 1);
                    }
                    return class_2489.method_23241((double)Double.parseDouble((String)input));
                }
                case 8: {
                    if (((String)input).startsWith("\"") && ((String)input).endsWith("\"")) {
                        input = ((String)input).substring(1, ((String)input).length() - 1);
                    }
                    return class_2519.method_23256((String)input);
                }
                case 9: {
                    return this.parseNbtList((String)input);
                }
                case 10: {
                    if (!((String)input).startsWith("{")) {
                        input = "{" + (String)input;
                    }
                    if (!((String)input).endsWith("}")) {
                        input = (String)input + "}";
                    }
                    return class_2522.method_10718((String)input);
                }
                case 7: {
                    if (!((String)input).startsWith("[B;")) {
                        input = "[B;" + (String)input;
                    }
                    if (!((String)input).endsWith("]")) {
                        input = (String)input + "]";
                    }
                    return class_2522.method_10718((String)input);
                }
                case 11: {
                    if (!((String)input).startsWith("[I;")) {
                        input = "[I;" + (String)input;
                    }
                    if (!((String)input).endsWith("]")) {
                        input = (String)input + "]";
                    }
                    return class_2522.method_10718((String)input);
                }
                case 12: {
                    if (!((String)input).startsWith("[L;")) {
                        input = "[L;" + (String)input;
                    }
                    if (!((String)input).endsWith("]")) {
                        input = (String)input + "]";
                    }
                    return class_2522.method_10718((String)input);
                }
            }
            throw new Exception("\u4e0d\u652f\u6301\u7684NBT\u7c7b\u578b: " + this.getTypeName(expectedType));
        }
        catch (NumberFormatException e) {
            throw new Exception(class_2561.method_43469((String)"entity_debugger.error.number_format", (Object[])new Object[]{e.getMessage()}).getString());
        }
        catch (CommandSyntaxException e) {
            String msg = e.getMessage();
            if (msg.contains("expected key")) {
                throw new Exception(class_2561.method_43471((String)"entity_debugger.error.compound_missing_key").getString());
            }
            if (msg.contains("at line") && msg.contains("column")) {
                throw new Exception(class_2561.method_43469((String)"entity_debugger.error.syntax_error", (Object[])new Object[]{msg.substring(msg.indexOf("line") + 5, msg.indexOf(",")), msg.substring(msg.indexOf("column") + 7, msg.indexOf(")"))}).getString());
            }
            if (msg.contains("Expected value")) {
                throw new Exception(class_2561.method_43471((String)"entity_debugger.error.missing_value").getString());
            }
            if (msg.contains("Invalid escape sequence")) {
                throw new Exception(class_2561.method_43471((String)"entity_debugger.error.invalid_escape").getString());
            }
            throw new Exception(class_2561.method_43469((String)"entity_debugger.error.nbt_format", (Object[])new Object[]{msg}).getString());
        }
        catch (Exception e) {
            throw new Exception(class_2561.method_43469((String)"entity_debugger.error.parse_failed", (Object[])new Object[]{this.getTypeName(expectedType), e.getMessage()}).getString());
        }
    }

    private void showError(String message) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43469((String)"entity_debugger.message.error", (Object[])new Object[]{message}), false);
        }
        EntityDebugger.LOGGER.error("NBT Error: {}", (Object)message);
    }

    private void showSuccess(String message) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43469((String)"entity_debugger.message.success", (Object[])new Object[]{message}), false);
        }
    }

    private String getTypeName(byte nbtType) {
        return class_2561.method_43469((String)("nbt.type." + (switch (nbtType) {
            case 0 -> "end";
            case 1 -> "byte";
            case 2 -> "short";
            case 3 -> "int";
            case 4 -> "long";
            case 5 -> "float";
            case 6 -> "double";
            case 7 -> "byte_array";
            case 8 -> "string";
            case 9 -> "list";
            case 10 -> "compound";
            case 11 -> "int_array";
            case 12 -> "long_array";
            default -> "unknown";
        })), (Object[])new Object[]{nbtType}).getString();
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.nbtKeys.size() / (double)this.itemsPerPage);
    }

    private void cleanupEditing() {
        if (this.activeEditor != null) {
            this.method_37066((class_364)this.activeEditor);
            this.activeEditor = null;
        }
        this.editingKey = null;
        this.method_25395(null);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.activeEditor != null) {
            if (keyCode == 257) {
                this.saveEditedValue();
                return true;
            }
            if (keyCode == 256) {
                this.cleanupEditing();
                return true;
            }
            return this.activeEditor.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        if (this.hasUnsavedChanges) {
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    this.saveAllChanges();
                }
                super.method_25419();
            }, (class_2561)class_2561.method_43471((String)"entity_debugger.dialog.unsaved_changes.title"), (class_2561)class_2561.method_43471((String)"entity_debugger.dialog.unsaved_changes.message")));
        } else {
            super.method_25419();
        }
    }

    static class InvalidNbtFormatException
    extends RuntimeException {
        public InvalidNbtFormatException(String message) {
            super(message);
        }
    }
}

