/*
 * Decompiled with CFR 0.152.
 */
package com.debugger.entity.screen;

import com.debugger.entity.screen.MultiLineTextFieldWidget;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class NbtListEditorWidget
extends MultiLineTextFieldWidget {
    private static final int BRACKET_COLOR = -16711681;
    private static final int BRACE_COLOR = -256;
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int CURSOR_COLOR = -1;
    private static final int SELECTION_COLOR = -2144128001;

    public NbtListEditorWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 message) {
        super(textRenderer, x, y, width, height, message);
        this.textRenderer = textRenderer;
        this.method_1888(true);
    }

    @Override
    protected void renderWrappedText(class_332 context) {
        String text = this.method_1882();
        int startY = this.method_46427() + 6;
        int maxWidth = this.method_25368() - 8;
        ArrayList<String> lines = new ArrayList<String>();
        int pos = 0;
        while (pos < text.length()) {
            int lineEnd = text.indexOf(10, pos);
            if (lineEnd == -1) {
                lineEnd = text.length();
            }
            String line = text.substring(pos, lineEnd);
            lines.add(line);
            pos = lineEnd + 1;
        }
        int yPos = startY;
        for (String line : lines) {
            int xPos = this.method_46426() + 4;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                String charStr = String.valueOf(c);
                int color = -1;
                if (c == '[' || c == ']') {
                    color = -16711681;
                } else if (c == '{' || c == '}') {
                    color = -256;
                }
                context.method_51433(this.textRenderer, charStr, xPos, yPos, color, false);
                xPos += this.textRenderer.method_1727(charStr);
            }
            Objects.requireNonNull(this.textRenderer);
            yPos += 9;
        }
        this.renderCursor(context);
    }

    private void renderCursor(class_332 context) {
        if (!this.method_25370()) {
            return;
        }
        String text = this.method_1882();
        int cursorPos = this.method_1881();
        String textBeforeCursor = text.substring(0, cursorPos);
        String[] lines = textBeforeCursor.split("\n", -1);
        int currentLine = lines.length - 1;
        String currentLineText = lines[currentLine];
        int cursorX = this.method_46426() + 4 + this.textRenderer.method_1727(currentLineText);
        int n = this.method_46427() + 6;
        Objects.requireNonNull(this.textRenderer);
        int cursorY = n + currentLine * 9;
        Objects.requireNonNull(this.textRenderer);
        context.method_25294(cursorX, cursorY, cursorX + 1, cursorY + 9, -1);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked;
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        boolean bl = clicked = mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        if (clicked) {
            this.method_25365(true);
            this.setCursorFromMousePos(mouseX, mouseY);
            return true;
        }
        return false;
    }

    private void setCursorFromMousePos(double mouseX, double mouseY) {
        int charWidth;
        int linePos;
        String text = this.method_1882();
        int relativeX = (int)mouseX - this.method_46426() - 4;
        int relativeY = (int)mouseY - this.method_46427() - 6;
        Objects.requireNonNull(this.textRenderer);
        int lineNumber = Math.max(0, relativeY / 9);
        String[] lines = text.split("\n", -1);
        if (lineNumber >= lines.length) {
            this.method_1883(text.length());
            return;
        }
        String line = lines[lineNumber];
        int accumulatedWidth = 0;
        for (linePos = 0; linePos < line.length() && accumulatedWidth + (charWidth = this.textRenderer.method_1727(line.substring(linePos, linePos + 1))) / 2 <= relativeX; ++linePos) {
            accumulatedWidth += charWidth;
        }
        int globalPos = 0;
        for (int i = 0; i < lineNumber; ++i) {
            globalPos += lines[i].length() + 1;
        }
        this.method_1883(globalPos += linePos);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 265: {
                this.moveCursorUp();
                return true;
            }
            case 264: {
                this.moveCursorDown();
                return true;
            }
            case 257: {
                this.method_1867("\n");
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void moveCursorUp() {
        int cursorPos = this.method_1881();
        String text = this.method_1882();
        if (text.isEmpty()) {
            return;
        }
        int lineStart = text.lastIndexOf(10, cursorPos - 1);
        if (lineStart == -1) {
            this.method_1883(0);
            return;
        }
        int prevLineStart = text.lastIndexOf(10, lineStart - 1);
        int lineOffset = cursorPos - lineStart - 1;
        if (prevLineStart == -1) {
            this.method_1883(Math.min(lineOffset, lineStart));
        } else {
            String prevLine = text.substring(prevLineStart + 1, lineStart);
            int newPos = prevLineStart + 1 + Math.min(lineOffset, prevLine.length());
            this.method_1883(newPos);
        }
    }

    private void moveCursorDown() {
        int nextLineStart;
        int cursorPos = this.method_1881();
        String text = this.method_1882();
        if (text.isEmpty()) {
            return;
        }
        int lineEnd = text.indexOf(10, cursorPos);
        if (lineEnd == -1) {
            lineEnd = text.length();
        }
        if ((nextLineStart = lineEnd + 1) >= text.length()) {
            this.method_1883(text.length());
            return;
        }
        int nextLineEnd = text.indexOf(10, nextLineStart);
        if (nextLineEnd == -1) {
            nextLineEnd = text.length();
        }
        int lineOffset = cursorPos - (text.lastIndexOf(10, cursorPos) + 1);
        String nextLine = text.substring(nextLineStart, nextLineEnd);
        int newPos = nextLineStart + Math.min(lineOffset, nextLine.length());
        this.method_1883(newPos);
    }
}

