package forestry.api.arboriculture;

import net.minecraft.resources.ResourceLocation;

import static forestry.api.ForestryConstants.forestry;

/**
 * IDs of all tree species registered by base Forestry.
 * The "tree_" prefix avoids ID conflicts because all types of species share the same registry (alleles).
 */
public class ForestryTreeSpecies {
	public static final ResourceLocation OAK = forestry("tree_oak");
	public static final ResourceLocation DARK_OAK = forestry("tree_dark_oak");
	public static final ResourceLocation BIRCH = forestry("tree_birch");
	/**
	 * The species for the Acacia trees added by Vanilla Minecraft.
	 */
	public static final ResourceLocation ACACIA_VANILLA = forestry("tree_acacia");
	public static final ResourceLocation SPRUCE = forestry("tree_spruce");
	public static final ResourceLocation JUNGLE = forestry("tree_jungle");
	/**
	 * The species for the Cherry Blossom trees added by Vanilla Minecraft.
	 */
	public static final ResourceLocation CHERRY_VANILLA = forestry("tree_cherry");
	public static final ResourceLocation LIME = forestry("tree_lime");
	public static final ResourceLocation WALNUT = forestry("tree_walnut");
	public static final ResourceLocation CHESTNUT = forestry("tree_chestnut");
	public static final ResourceLocation HILL_CHERRY = forestry("tree_hill_cherry");
	public static final ResourceLocation LEMON = forestry("tree_lemon");
	public static final ResourceLocation PLUM = forestry("tree_plum");
	public static final ResourceLocation MAPLE = forestry("tree_maple");
	public static final ResourceLocation LARCH = forestry("tree_larch");
	public static final ResourceLocation PINE = forestry("tree_pine");
	public static final ResourceLocation SEQUOIA = forestry("tree_sequoia");
	public static final ResourceLocation GIANT_SEQUOIA = forestry("tree_giant_sequoia");
	public static final ResourceLocation TEAK = forestry("tree_teak");
	public static final ResourceLocation IPE = forestry("tree_ipe");
	public static final ResourceLocation KAPOK = forestry("tree_kapok");
	public static final ResourceLocation EBONY = forestry("tree_ebony");
	public static final ResourceLocation ZEBRAWOOD = forestry("tree_zebrawood");
	public static final ResourceLocation MAHOGANY = forestry("tree_mahogany");
	public static final ResourceLocation DESERT_ACACIA = forestry("tree_desert_acacia");
	public static final ResourceLocation PADAUK = forestry("tree_padauk");
	public static final ResourceLocation BALSA = forestry("tree_balsa");
	public static final ResourceLocation COCOBOLO = forestry("tree_cocobolo");
	public static final ResourceLocation WENGE = forestry("tree_wenge");
	public static final ResourceLocation BAOBAB = forestry("tree_baobab");
	public static final ResourceLocation MAHOE = forestry("tree_mahoe");
	public static final ResourceLocation WILLOW = forestry("tree_willow");
	public static final ResourceLocation SIPIRI = forestry("tree_sipiri");
	public static final ResourceLocation PAPAYA = forestry("tree_papaya");
	public static final ResourceLocation DATE = forestry("tree_date");
	public static final ResourceLocation POPLAR = forestry("tree_poplar");
}
