package forestry.api.farming;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

import java.util.List;

/**
 * Helper interface that every farm inventory implements.
 * <p>
 * Handles the inventory and item management of the farm. Which item the farm will accept is defined by the
 * {@link IFarmLogic}'s and the {@link IFarmType}.
 */
public interface IFarmInventory {
	/**
	 * Checks if the inventory contains the given resources.
	 *
	 * @param resources A list of items to check
	 * @return True if the inventory contains the resources; false otherwise.
	 */
	boolean hasResources(List<ItemStack> resources);

	/**
	 * Remove the given resource from the inventory, if possible
	 *
	 * @param resources A list of items to remove
	 */
	void removeResources(List<ItemStack> resources);

	/**
	 * Checks if the inventory will accept the given stack as a sapling
	 *
	 * @param stack The stack to check
	 * @return True if the stack is valid; false otherwise
	 */
	boolean acceptsAsSeedling(ItemStack stack);

	/**
	 * Checks if the inventory will accept the given stack as a resource
	 *
	 * @param stack The stack to check
	 * @return True if the stack is valid; false otherwise
	 */
	boolean acceptsAsResource(ItemStack stack);

	/**
	 * Checks if the inventory will accept the given stack as a fertelizer
	 *
	 * @param stack The stack to check
	 * @return True if the stack is valid; false otherwise
	 */
	boolean acceptsAsFertilizer(ItemStack stack);

	/**
	 * Sub-inventory that contains only the output
	 */
	Container getProductInventory();

	/**
	 * Sub-inventory that contains only the germlings
	 */
	Container getGermlingsInventory();

	/**
	 * Sub-inventory that contains only the resources
	 */
	Container getResourcesInventory();

	/**
	 * Sub-inventory that contains only the fertilizer
	 */
	Container getFertilizerInventory();
}
