package forestry.api.arboriculture;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

import javax.annotation.Nullable;
import java.util.List;

/**
 * Provides functions that are related to the forestry charcoal pile.
 */
@Deprecated
public interface ICharcoalManager {
	/**
	 * Registers the given block as a valid block for the charcoal pile wall and adds the given charcoal amount to it.
	 * <p>
	 * This method unlike {@link #registerWall(BlockState, int)} ignores the metadata of the actual block and
	 * only compares the world block with the given block.
	 *
	 * @deprecated Use {@link forestry.api.plugin.IArboricultureRegistration#registerCharcoalPitWall}
	 */
	@Deprecated(forRemoval = true)
	void registerWall(Block block, int amount);

	/**
	 * Registers the given block as a valid block for the charcoal pile wall and adds the given charcoal amount to it.
	 * <p>
	 * This method unlike {@link #registerWall(Block, int)} compares the world state with the given state and not
	 * only the block.
	 *
	 * @deprecated Use {@link forestry.api.plugin.IArboricultureRegistration#registerCharcoalPitWall}
	 */
	@Deprecated(forRemoval = true)
	void registerWall(BlockState blockState, int amount);

	/**
	 * Registers your implementation of the {@link ICharcoalPileWall} interface.
	 *
	 * @deprecated Use {@link forestry.api.plugin.IArboricultureRegistration#registerCharcoalPitWall}
	 */
	@Deprecated(forRemoval = true)
	void registerWall(ICharcoalPileWall wall);

	@Nullable
	ICharcoalPileWall getWall(BlockState state);

	/**
	 * Remove a wall associated with the given block. Not guaranteed to work depending on how {@link ICharcoalPileWall} is implemented.
	 * {@link #removeWall(BlockState)} is preferred.
	 *
	 * @return true if the wall was removed.
	 * @deprecated Use {@link forestry.api.plugin.IArboricultureRegistration#registerCharcoalPitWall} and set to 0
	 */
	@Deprecated(forRemoval = true)
	boolean removeWall(Block block);

	/**
	 * Remove a wall that {@link ICharcoalPileWall#matches(BlockState)} the given blockstate.
	 *
	 * @param state the blockstate to remove.
	 * @return true if the wall was removed.
	 * @deprecated Use {@link forestry.api.plugin.IArboricultureRegistration#registerCharcoalPitWall} and set to 0
	 */
	@Deprecated(forRemoval = true)
	boolean removeWall(BlockState state);

	/**
	 * @return A collection with all registered charcoal pile walls.
	 */
	List<ICharcoalPileWall> getWalls();
}
