package forestry.api.multiblock;

import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.climate.IClimateControlled;

/**
 * Needs to be implemented by TileEntities that want to be part of an alveary.
 * The sub-interfaces can be implemented to alter the operation of the alveary.
 * They are automatically detected and handled by the alveary when they join its structure.
 */
public interface IAlvearyComponent<T extends IMultiblockLogicAlveary> extends IMultiblockComponent {
	/**
	 * @return the multiblock logic for this component
	 */
	@Override
	T getMultiblockLogic();

	/**
	 * Implemented by alveary parts to apply a beeListener to the completed structure.
	 */
	interface BeeListener<T extends IMultiblockLogicAlveary> extends IAlvearyComponent<T> {
		IBeeListener getBeeListener();
	}

	/**
	 * Implemented by alveary parts to apply a beeModifier to the completed structure.
	 */
	interface BeeModifier<T extends IMultiblockLogicAlveary> extends IAlvearyComponent<T> {
		IBeeModifier getBeeModifier();
	}

	/**
	 * Implemented by alveary parts to apply a climate change to the completed structure.
	 */
	interface Climatiser<T extends IMultiblockLogicAlveary> extends IAlvearyComponent<T> {
		/**
		 * Called every tick by the alveary.
		 *
		 * @param tickCount the number of ticks in the world
		 * @param alveary   the climate controlled alveary
		 */
		void changeClimate(int tickCount, IClimateControlled alveary);
	}

	/**
	 * Implemented by alveary parts to receive ticks from the completed structure.
	 */
	interface Active<T extends IMultiblockLogicAlveary> extends IAlvearyComponent<T> {
		void updateServer(int tickCount);

		void updateClient(int tickCount);
	}
}
