/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeJubilance;
import forestry.api.apiculture.IJubilanceFactory;
import net.minecraft.world.level.block.state.BlockState;

public class JubilanceFactory implements IJubilanceFactory {
	@Override
	public IBeeJubilance getDefault() {
		return DefaultBeeJubilance.INSTANCE;
	}

	@Override
	public IBeeJubilance getHermit() {
		return HermitBeeJubilance.INSTANCE;
	}

	@Override
	public IBeeJubilance getRequiresResource(BlockState... acceptedBlockStates) {
		return new RequiresResourceBeeJubilance(acceptedBlockStates);
	}
}
