package forestry.arboriculture.client;

import forestry.api.client.arboriculture.ILeafTint;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;

// Based on the block color for Oak, Jungle, Dark Oak, and Acacia leaves
public class BiomeLeafTint implements ILeafTint {
	public static final BiomeLeafTint DEFAULT = new BiomeLeafTint();

	@Override
	public int get(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
		if (level != null && pos != null) {
			return BiomeColors.getAverageFoliageColor(level, pos);
		}
		// from FoliageColor.getDefaultColor
		return 0x48b518;
	}
}
