/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayerFactory;

import javax.annotation.Nullable;
import java.util.UUID;

public abstract class PlayerUtil {
	//TODO: use null everywhere instead of an emptyUUID
	private static final UUID emptyUUID = new UUID(0, 0);

	public static boolean isSameGameProfile(GameProfile player1, GameProfile player2) {
		UUID id1 = player1.getId();
		UUID id2 = player2.getId();
		if (id1 != null && id2 != null && !id1.equals(emptyUUID) && !id2.equals(emptyUUID)) {
			return id1.equals(id2);
		}

		return player1.getName() != null && player1.getName().equals(player2.getName());
	}

	public static String getOwnerName(@Nullable GameProfile profile) {
		if (profile == null) {
			return Component.translatable("for.gui.derelict").getString();
		} else {
			return profile.getName();
		}
	}

	/**
	 * Get a player for a given World and GameProfile.
	 * If they are not in the World, returns a FakePlayer.
	 * Do not store references to the return value, to prevent worlds staying in memory.
	 */
	@Nullable
	public static Player getPlayer(Level world, @Nullable GameProfile profile) {
		if (profile == null || profile.getName() == null) {
			if (world instanceof ServerLevel) {
				return FakePlayerFactory.getMinecraft((ServerLevel) world);
			} else {
				return null;
			}
		}

		Player player = world.getPlayerByUUID(profile.getId());
		if (player == null && world instanceof ServerLevel) {
			player = FakePlayerFactory.get((ServerLevel) world, profile);
		}
		return player;
	}

	/**
	 * Get a fake player for a given World and GameProfile.
	 * Do not store references to the return value, to prevent worlds staying in memory.
	 */
	@Nullable
	public static Player getFakePlayer(Level world, @Nullable GameProfile profile) {
		if (profile == null || profile.getName() == null) {
			if (world instanceof ServerLevel) {
				return FakePlayerFactory.getMinecraft((ServerLevel) world);
			} else {
				return null;
			}
		}

		if (world instanceof ServerLevel) {
			return FakePlayerFactory.get((ServerLevel) world, profile);
		}
		return null;
	}
}
