package forestry.energy.screen;

import forestry.core.config.Constants;
import forestry.core.gui.widgets.TankWidget;
import forestry.energy.menu.BiogasEngineMenu;
import forestry.energy.tiles.BiogasEngineBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class BiogasEngineScreen extends EngineScreen<BiogasEngineMenu, BiogasEngineBlockEntity> {
	public BiogasEngineScreen(BiogasEngineMenu menu, Inventory inv, Component title) {
		super(Constants.TEXTURE_PATH_GUI + "/bioengine.png", menu, inv, title, menu.getTile());

        this.widgetManager.add(new TankWidget(this.widgetManager, 89, 19, 0));
        this.widgetManager.add(new TankWidget(this.widgetManager, 107, 19, 1));

        this.widgetManager.add(new BiogasSlot(this.widgetManager, 30, 47, 2));
	}

	@Override
	protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
		super.renderBg(graphics, partialTicks, mouseX, mouseY);

		int temperature = this.engine.getOperatingTemperatureScaled(16);
		if (temperature > 16) {
			temperature = 16;
		}
		if (temperature > 0) {
			graphics.blit(this.textureFile, this.leftPos + 53, this.topPos + 47 + 16 - temperature, 176, 60 + 16 - temperature, 4, temperature);
		}
	}
}
