/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.core.IProduct;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record Product(Item item, int count, @Nullable CompoundTag tag, float chance) implements IProduct
{
    public static final Codec<Product> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("item").forGetter(Product::item), (App)Codec.intRange((int)1, (int)64).optionalFieldOf("count", (Object)1).forGetter(Product::count), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(product -> Optional.ofNullable(product.tag)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(Product::chance)).apply((Applicative)instance, (item, count, tag, chance) -> new Product((Item)item, (int)count, tag.orElse(null), chance.floatValue())));

    @Override
    public ItemStack createStack() {
        ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
        if (this.tag != null) {
            stack.m_41751_(this.tag.m_6426_());
        }
        return stack;
    }

    public static Product of(Item item) {
        return new Product(item, 1, null, 1.0f);
    }

    public static Product of(Item item, int amount, float chance) {
        return new Product(item, amount, null, chance);
    }

    public static void toNetwork(FriendlyByteBuf buffer, Product product) {
        buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)product.item);
        buffer.writeByte(product.count);
        buffer.m_130079_(product.tag);
        buffer.writeFloat(product.chance);
    }

    public static Product fromNetwork(FriendlyByteBuf buffer) {
        Item item = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
        byte count = buffer.readByte();
        CompoundTag tag = buffer.m_130260_();
        float chance = buffer.readFloat();
        if (item == null) {
            throw new IllegalStateException("Received invalid item ID");
        }
        return new Product(item, count, tag, chance);
    }
}

