/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics;

import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.ITaxon;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public interface IGeneticManager {
    public ITaxon getTaxon(String var1);

    public ITaxon[] getParentTaxa(String var1);

    public <S extends ISpecies<?>> IMutationManager<S> getMutations(ISpeciesType<?, ?> var1);

    default public <S extends ISpecies<?>> IMutationManager<S> getMutations(ResourceLocation speciesTypeId) {
        return this.getMutations(this.getSpeciesType(speciesTypeId));
    }

    public ISpeciesType<?, ?> getSpeciesType(ResourceLocation var1);

    @Nullable
    public ISpeciesType<?, ?> getSpeciesTypeSafe(ResourceLocation var1);

    default public <T extends ISpeciesType<?, ?>> T getSpeciesType(ResourceLocation speciesTypeId, Class<T> typeClass) {
        return (T)((ISpeciesType)typeClass.cast(this.getSpeciesType(speciesTypeId)));
    }

    default public <I extends IIndividual> I createDefaultIndividual(ResourceLocation typeId) {
        Object o = this.getSpeciesType(typeId).cast();
        return o.getDefaultSpecies().createIndividual();
    }

    public Collection<ISpeciesType<?, ?>> getSpeciesTypes();
}

