/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics.alleles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.genetics.alleles.IAllele;
import net.minecraft.util.RandomSource;

public record AllelePair<A extends IAllele>(A active, A inactive) {
    public static final Codec<AllelePair<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IAllele.CODEC.fieldOf("active").forGetter(AllelePair::active), (App)IAllele.CODEC.fieldOf("inactive").forGetter(AllelePair::inactive)).apply((Applicative)instance, AllelePair::new));

    public static <A extends IAllele> AllelePair<A> both(A allele) {
        return new AllelePair<A>(allele, allele);
    }

    public AllelePair<A> inheritOther(RandomSource rand, AllelePair<A> other) {
        A secondChoice;
        A firstChoice = rand.m_188499_() ? this.active() : this.inactive();
        A a = secondChoice = rand.m_188499_() ? other.active() : other.inactive();
        if (rand.m_188499_()) {
            return AllelePair.create(firstChoice, secondChoice);
        }
        return AllelePair.create(secondChoice, firstChoice);
    }

    public AllelePair<A> inheritHaploid(RandomSource rand) {
        A choice = rand.m_188499_() ? this.active() : this.inactive();
        return AllelePair.create(choice, choice);
    }

    public boolean isSameAlleles() {
        return this.active == this.inactive;
    }

    public static <A extends IAllele> AllelePair<A> create(A firstAllele, A secondAllele) {
        return new AllelePair<A>(AllelePair.getActiveAllele(firstAllele, secondAllele), AllelePair.getInactiveAllele(firstAllele, secondAllele));
    }

    private static <A extends IAllele> A getActiveAllele(A firstAllele, A secondAllele) {
        if (firstAllele.dominant()) {
            return firstAllele;
        }
        if (secondAllele.dominant()) {
            return secondAllele;
        }
        return firstAllele;
    }

    private static <A extends IAllele> A getInactiveAllele(A firstAllele, A secondAllele) {
        if (!secondAllele.dominant()) {
            return secondAllele;
        }
        if (!firstAllele.dominant()) {
            return firstAllele;
        }
        return secondAllele;
    }
}

