/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;

public class FertileBeeEffect
extends ThrottledBeeEffect {
    private static final int MAX_BLOCK_FIND_TRIES = 5;

    public FertileBeeEffect() {
        super(false, 6, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        BlockPos housingCoordinates = housing.getCoordinates();
        Vec3i area = Bee.getParticleArea(genome, housing);
        int blockX = FertileBeeEffect.getRandomOffset(level.f_46441_, housingCoordinates.m_123341_(), area.m_123341_());
        int blockZ = FertileBeeEffect.getRandomOffset(level.f_46441_, housingCoordinates.m_123343_(), area.m_123343_());
        int blockMaxY = housingCoordinates.m_123342_() + area.m_123342_() / 2 + 1;
        int blockMinY = housingCoordinates.m_123342_() - area.m_123342_() / 2 - 1;
        for (int attempt = 0; attempt < 5; ++attempt) {
            if (level.m_7726_().m_7131_(blockX >> 4, blockZ >> 4) == null) continue;
            if (FertileBeeEffect.tryTickColumn(level, blockX, blockZ, blockMaxY, blockMinY)) break;
            blockX = FertileBeeEffect.getRandomOffset(level.f_46441_, housingCoordinates.m_123341_(), area.m_123341_());
            blockZ = FertileBeeEffect.getRandomOffset(level.f_46441_, housingCoordinates.m_123343_(), area.m_123343_());
        }
        return storedData;
    }

    private static int getRandomOffset(RandomSource random, int centrePos, int offset) {
        return centrePos + random.m_188503_(offset) - offset / 2;
    }

    private static boolean tryTickColumn(Level level, int x, int z, int maxY, int minY) {
        for (int y = maxY; y >= minY; --y) {
            BlockState state = level.m_8055_(new BlockPos(x, y, z));
            Block block = state.m_60734_();
            if (!block.m_6724_(state) || !(block instanceof BonemealableBlock) && !(block instanceof IPlantable)) continue;
            level.m_186460_(new BlockPos(x, y, z), block, 5);
            return true;
        }
        return false;
    }
}

