/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.damage.CoreDamageTypes;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.VecUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RadioactiveBeeEffect
extends ThrottledBeeEffect {
    public RadioactiveBeeEffect() {
        super(true, 40, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.harmEntities(genome, housing);
        return RadioactiveBeeEffect.destroyEnvironment(genome, storedData, housing);
    }

    private void harmEntities(IGenome genome, IBeeHousing housing) {
        List<LivingEntity> entities = ThrottledBeeEffect.getEntitiesInRange(genome, housing, LivingEntity.class);
        for (LivingEntity entity : entities) {
            int damage = 8;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this, true);
            if ((damage -= count * 2) <= 0) continue;
            entity.m_6469_(CoreDamageTypes.source((LevelReader)housing.getWorldObj(), CoreDamageTypes.RADIOACTIVE), (float)damage);
        }
    }

    private static IEffectData destroyEnvironment(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        RandomSource rand = level.f_46441_;
        BlockPos area = VecUtil.scale(genome.getActiveValue(BeeChromosomes.TERRITORY), 2.0f);
        BlockPos posHousing = housing.getCoordinates();
        for (int i = 0; i < 20; ++i) {
            BlockEntity tile;
            BlockState state;
            BlockPos randomPos = VecUtil.getRandomPositionInArea(rand, (Vec3i)area);
            BlockPos posBlock = randomPos.m_121955_((Vec3i)posHousing).m_121955_(VecUtil.center((Vec3i)area));
            if (posBlock.m_123342_() <= 1 || posBlock.m_123342_() >= level.m_151558_() || posBlock.m_123341_() == posHousing.m_123341_() && posBlock.m_123343_() == posHousing.m_123343_() && posBlock.m_123342_() <= posHousing.m_123342_() || !level.m_46805_(posBlock) || level.m_46859_(posBlock) || (state = level.m_8055_(posBlock)).m_60734_() instanceof BlockAlveary || (tile = TileUtil.getTile((BlockGetter)level, posBlock)) instanceof IBeeHousing || state.m_60800_((BlockGetter)level, posBlock) < 0.0f) continue;
            BlockUtil.setBlockToAirWithSound(level, posBlock, state);
            break;
        }
        return storedData;
    }
}

