/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.entities.AIAvoidPlayers;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import java.util.List;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;

public class RepulsionBeeEffect
extends ThrottledBeeEffect {
    public RepulsionBeeEffect() {
        super(false, 100, true, true);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        List<Monster> mobs = ThrottledBeeEffect.getEntitiesInRange(genome, housing, Monster.class);
        for (Monster mob : mobs) {
            if (this.isMobAvoidingPlayers(mob)) continue;
            mob.f_21345_.m_25352_(3, (Goal)new AIAvoidPlayers((PathfinderMob)mob, 6.0f, 0.25f, 0.3f));
            mob.f_21345_.m_25373_();
        }
        return storedData;
    }

    private boolean isMobAvoidingPlayers(Monster mob) {
        return mob.f_21345_.m_25386_().anyMatch(task -> task.m_26015_() instanceof AIAvoidPlayers);
    }
}

