/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.utils.VecUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SculkSpreadBeeEffect
extends ThrottledBeeEffect {
    public SculkSpreadBeeEffect() {
        super(false, 200, true, true);
    }

    @Override
    IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        if (level.f_46443_) {
            return storedData;
        }
        RandomSource random = level.f_46441_;
        Vec3i area = Bee.getParticleArea(genome, housing);
        BlockPos randomPos = VecUtil.getRandomPositionInArea(random, area);
        BlockPos posBlock = randomPos.m_121955_((Vec3i)housing.getCoordinates()).m_121955_(VecUtil.center(area));
        if (level.m_46805_(posBlock)) {
            BlockState state = level.m_8055_(posBlock);
            if (state.m_60795_() && !level.m_8055_(posBlock.m_7495_()).m_60795_()) {
                SculkSpreader spreader = SculkSpreader.m_222254_();
                spreader.m_222266_(posBlock, random.m_188503_(5) + 1);
                spreader.m_222255_((LevelAccessor)level, housing.getCoordinates(), random, true);
                spreader.m_222255_((LevelAccessor)level, housing.getCoordinates(), random, true);
                spreader.m_222255_((LevelAccessor)level, housing.getCoordinates(), random, true);
                spreader.m_222255_((LevelAccessor)level, housing.getCoordinates(), random, true);
                spreader.m_222255_((LevelAccessor)level, housing.getCoordinates(), random, true);
            } else if (state.m_60734_() == Blocks.f_220858_) {
                level.m_46597_(posBlock.m_7494_(), (BlockState)Blocks.f_220858_.m_49966_().m_61124_((Property)SculkShriekerBlock.f_222154_, (Comparable)Boolean.valueOf(true)));
            }
        }
        return storedData;
    }
}

