/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiimpl.plugin;

import com.google.common.collect.ImmutableMap;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmType;
import forestry.api.plugin.IFarmTypeBuilder;
import forestry.api.plugin.IFarmingRegistration;
import forestry.apiimpl.plugin.FarmTypeBuilder;
import forestry.apiimpl.plugin.ModifiableRegistrar;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FarmingRegistration
implements IFarmingRegistration {
    private final ModifiableRegistrar<ResourceLocation, IFarmTypeBuilder, FarmTypeBuilder> farmTypes = new ModifiableRegistrar(IFarmTypeBuilder.class);
    private final Object2IntOpenHashMap<Item> fertilizers = new Object2IntOpenHashMap();

    @Override
    public IFarmTypeBuilder createFarmType(ResourceLocation id, BiFunction<IFarmType, Boolean, IFarmLogic> logicFactory, ItemStack icon) {
        return (IFarmTypeBuilder)this.farmTypes.create(id, new FarmTypeBuilder(id, logicFactory, icon));
    }

    @Override
    public void modifyFarmType(ResourceLocation id, Consumer<IFarmTypeBuilder> action) {
        this.farmTypes.modify(id, action);
    }

    @Override
    public void registerFertilizer(Item fertilizer, int amount) {
        this.fertilizers.put((Object)fertilizer, amount);
    }

    public Object2IntOpenHashMap<Item> getFertilizers() {
        return this.fertilizers;
    }

    public ImmutableMap<ResourceLocation, IFarmType> buildFarmTypes() {
        return this.farmTypes.build(FarmTypeBuilder::build);
    }
}

