/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiimpl.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.ITaxon;
import forestry.api.genetics.TaxonomicRank;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.api.plugin.IGeneticRegistration;
import forestry.api.plugin.ISpeciesTypeBuilder;
import forestry.api.plugin.ISpeciesTypeFactory;
import forestry.api.plugin.ITaxonBuilder;
import forestry.apiimpl.plugin.ModifiableRegistrar;
import forestry.apiimpl.plugin.SpeciesTypeBuilder;
import forestry.core.genetics.Taxon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public final class GeneticRegistration
implements IGeneticRegistration {
    private final HashMap<String, TaxonBuilder> taxaByName = new HashMap();
    private final HashMap<String, HashSet<String>> unknownTaxa = new HashMap();
    private final HashMap<String, Consumer<ITaxonBuilder>> unknownActions = new HashMap();
    private final ModifiableRegistrar<ResourceLocation, ISpeciesTypeBuilder, SpeciesTypeBuilder> speciesTypes = new ModifiableRegistrar(ISpeciesTypeBuilder.class);
    private final ArrayList<IFilterRuleType> ruleTypes = new ArrayList();

    public GeneticRegistration() {
        TaxonBuilder prokaryota = this.registerTaxon(TaxonomicRank.DOMAIN, "prokaryota");
        prokaryota.defineSubTaxon("archaea");
        prokaryota.defineSubTaxon("bacteria");
        TaxonBuilder eukaryota = this.registerTaxon(TaxonomicRank.DOMAIN, "eukaryota");
        eukaryota.defineSubTaxon("fungi");
        eukaryota.defineSubTaxon("plantae");
        eukaryota.defineSubTaxon("animalia", animalia -> animalia.defineSubTaxon("arthropoda", arthropoda -> arthropoda.defineSubTaxon("insecta")));
        eukaryota.defineSubTaxon("protozoa");
        eukaryota.defineSubTaxon("chromista");
    }

    @Override
    public void defineTaxon(String parent, String name) {
        if (this.taxaByName.containsKey(parent)) {
            this.taxaByName.get(parent).defineSubTaxon(name);
        } else {
            this.unknownTaxa.computeIfAbsent(parent, key -> new HashSet()).add(name);
        }
    }

    @Override
    public void defineTaxon(String parent, String name, Consumer<ITaxonBuilder> action) {
        if (this.taxaByName.containsKey(parent)) {
            this.taxaByName.get(parent).defineSubTaxon(name, action);
        } else {
            this.unknownTaxa.computeIfAbsent(parent, key -> new HashSet()).add(name);
            this.unknownActions.put(name, action);
        }
    }

    @Override
    public ISpeciesTypeBuilder registerSpeciesType(ResourceLocation id, ISpeciesTypeFactory factory) {
        return (ISpeciesTypeBuilder)this.speciesTypes.create(id, new SpeciesTypeBuilder(factory));
    }

    @Override
    public void modifySpeciesType(ResourceLocation id, Consumer<ISpeciesTypeBuilder> action) {
        this.speciesTypes.modify(id, action);
    }

    public ImmutableMap<ResourceLocation, ISpeciesType<?, ?>> buildSpeciesTypes() {
        return this.speciesTypes.build(SpeciesTypeBuilder::build);
    }

    private TaxonBuilder registerTaxon(TaxonomicRank rank, String name) {
        if (this.taxaByName.containsKey(name)) {
            TaxonBuilder existing = this.taxaByName.get(name);
            if (existing.rank == rank) {
                return existing;
            }
            throw new RuntimeException("A taxon with name '" + name + "' is already defined in rank " + existing + " but plugin tried to set it in rank " + rank);
        }
        TaxonBuilder builder = new TaxonBuilder(this, rank, name);
        this.taxaByName.put(name, builder);
        HashSet<String> dependents = this.unknownTaxa.remove(name);
        if (dependents != null) {
            for (String childName : dependents) {
                Consumer<ITaxonBuilder> action = this.unknownActions.remove(childName);
                if (action != null) {
                    builder.defineSubTaxon(name, action);
                    continue;
                }
                builder.defineSubTaxon(name);
            }
        }
        return builder;
    }

    @Override
    public void registerFilterRuleType(IFilterRuleType ruleType) {
        this.ruleTypes.add(ruleType);
    }

    public ImmutableMap<String, ITaxon> buildTaxa() {
        if (!this.unknownTaxa.isEmpty()) {
            StringBuilder msg = new StringBuilder("The following taxa were not registered, but are parents of registered taxa: ");
            this.unknownTaxa.forEach((parent, children) -> msg.append("\n'").append((String)parent).append("' is needed by registered subtaxa: ").append(Arrays.toString(children.toArray())));
            throw new IllegalStateException(msg.toString());
        }
        LinkedHashMap<String, Taxon> taxa = new LinkedHashMap<String, Taxon>(this.taxaByName.size());
        TaxonBuilder[] builders = this.taxaByName.values().toArray(new TaxonBuilder[0]);
        Arrays.sort(builders, Comparator.comparing(taxon -> taxon.rank));
        IdentityHashMap<Taxon, ImmutableList.Builder> parentChildrenMap = new IdentityHashMap<Taxon, ImmutableList.Builder>(this.taxaByName.size());
        for (TaxonBuilder builder : builders) {
            String name = builder.name;
            TaxonomicRank rank = builder.rank;
            Taxon parent2 = builder.parent == null ? null : (Taxon)taxa.get(builder.parent.name);
            IdentityHashMap<IChromosome<?>, ITaxon.TaxonAllele> alleles = builder.alleles;
            Taxon taxon2 = new Taxon(name, rank, parent2, alleles);
            taxa.put(name, taxon2);
            int childrenCount = builder.children.size();
            if (childrenCount > 0) {
                parentChildrenMap.put(taxon2, ImmutableList.builderWithExpectedSize((int)childrenCount));
            } else {
                taxon2.setChildren(List.of());
            }
            if (parent2 == null) continue;
            ((ImmutableList.Builder)parentChildrenMap.get(parent2)).add((Object)taxon2);
        }
        for (Map.Entry entry : parentChildrenMap.entrySet()) {
            ((Taxon)entry.getKey()).setChildren((List<ITaxon>)((ImmutableList.Builder)entry.getValue()).build());
        }
        return ImmutableMap.copyOf(taxa);
    }

    public ArrayList<IFilterRuleType> getFilterRuleTypes() {
        return this.ruleTypes;
    }

    private static class TaxonBuilder
    implements ITaxonBuilder {
        private final GeneticRegistration registration;
        private final TaxonomicRank rank;
        private final String name;
        private final HashSet<TaxonBuilder> children = new HashSet();
        private final IdentityHashMap<IChromosome<?>, ITaxon.TaxonAllele> alleles = new IdentityHashMap();
        @Nullable
        private TaxonBuilder parent;

        private TaxonBuilder(GeneticRegistration registration, TaxonomicRank rank, String name) {
            this.registration = registration;
            this.rank = rank;
            this.name = name;
        }

        @Override
        public void defineSubTaxon(String name) {
            this.registerChild(name);
        }

        @Override
        public void defineSubTaxon(String name, Consumer<ITaxonBuilder> action) {
            action.accept(this.registerChild(name));
        }

        private TaxonBuilder registerChild(String name) {
            if (this.rank == TaxonomicRank.GENUS) {
                throw new UnsupportedOperationException("Cannot directly add species '" + name + "' as a child of the '" + this.name + "' genus. Genera are populated by the ISpeciesBuilder");
            }
            TaxonBuilder existing = this.registration.taxaByName.get(name);
            if (existing != null && existing.parent != this) {
                String parentName = existing.parent == null ? "null" : existing.parent.name;
                throw new IllegalStateException("Tried to set a taxon with name '" + name + "' as child of taxon '" + this.name + "' but that taxon is already a child of a taxon named'" + parentName + "'");
            }
            TaxonBuilder child = this.registration.registerTaxon(this.rank.next(), name);
            this.children.add(child);
            child.parent = this;
            return child;
        }

        @Override
        public <A extends IAllele> void setDefaultChromosome(IChromosome<A> chromosome, A value, boolean required) {
            this.alleles.put(chromosome, new ITaxon.TaxonAllele(value, required));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaxonBuilder that = (TaxonBuilder)o;
            if (this.rank != that.rank) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.rank.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

