/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiimpl.plugin;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Registrar<K, I, V extends I> {
    protected final LinkedHashMap<K, V> values = new LinkedHashMap();
    protected final Class<I> interfaceType;

    public Registrar(Class<I> interfaceType) {
        this.interfaceType = interfaceType;
    }

    public I create(K key, V value) {
        if (this.values.containsKey(key)) {
            throw new IllegalStateException("A " + this.interfaceType.getSimpleName() + " already exists with key " + key + ": " + this.values.get(key));
        }
        this.values.put(key, value);
        return (I)value;
    }

    protected LinkedHashMap<K, V> getValues() {
        return this.values;
    }

    public ImmutableMap<K, V> build() {
        return ImmutableMap.copyOf(this.values);
    }

    public <T> ImmutableMap<K, T> build(Function<V, T> build) {
        return this.build((K key, V value) -> build.apply(value));
    }

    public <T> ImmutableMap<K, T> build(BiFunction<K, V, T> build) {
        LinkedHashMap<K, V> values = this.getValues();
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)values.size());
        for (Map.Entry entry : ((HashMap)values).entrySet()) {
            Object key = entry.getKey();
            builder.put(key, build.apply(key, entry.getValue()));
        }
        return builder.buildOrThrow();
    }
}

