/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiimpl.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import forestry.Forestry;
import forestry.api.IForestryApi;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.ITaxon;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.alleles.IRegistryChromosome;
import forestry.api.plugin.IGenomeBuilder;
import forestry.api.plugin.ISpeciesBuilder;
import forestry.apiimpl.plugin.ModifiableRegistrar;
import forestry.apiimpl.plugin.MutationsRegistration;
import forestry.core.genetics.MutationManager;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public abstract class SpeciesRegistration<I extends ISpeciesBuilder<? extends ISpeciesType<S, ?>, S, I>, S extends ISpecies<?>, B extends I> {
    private final ModifiableRegistrar<ResourceLocation, I, B> species = new ModifiableRegistrar(ISpeciesBuilder.class);
    protected final ISpeciesType<S, ?> type;

    public SpeciesRegistration(ISpeciesType<S, ?> type) {
        this.type = type;
    }

    protected abstract B createSpeciesBuilder(ResourceLocation var1, String var2, String var3, MutationsRegistration var4);

    protected I register(ResourceLocation id, String genus, String species) {
        return (I)((ISpeciesBuilder)this.species.create(id, this.createSpeciesBuilder(id, genus, species, new MutationsRegistration(id))));
    }

    public void modifySpecies(ResourceLocation id, Consumer<I> action) {
        this.species.modify(id, action);
    }

    public Pair<ImmutableMap<ResourceLocation, S>, IMutationManager<S>> buildAll() {
        IKaryotype karyotype = this.type.getKaryotype();
        IRegistryChromosome<ISpecies<?>> speciesChromosome = karyotype.getSpeciesChromosome();
        ImmutableMap<ResourceLocation, ISpecies> allSpecies = this.species.build((id, builder) -> {
            ITaxon[] ancestry;
            IGenomeBuilder defaultGenomeBuilder = karyotype.createGenomeBuilder();
            for (ITaxon taxon : ancestry = IForestryApi.INSTANCE.getGeneticManager().getParentTaxa(builder.getGenus())) {
                for (Map.Entry<IChromosome<?>, ITaxon.TaxonAllele> alleleEntry : taxon.alleles().entrySet()) {
                    IAllele allele = alleleEntry.getValue().allele();
                    IChromosome<?> chromosome = alleleEntry.getKey();
                    if (karyotype.isAlleleValid(chromosome, allele.cast())) {
                        defaultGenomeBuilder.set(alleleEntry.getKey(), allele.cast());
                        continue;
                    }
                    Forestry.LOGGER.warn("Default allele set by taxon {} skipped for species {} due to being invalid for its karyotype", (Object)taxon.name(), id);
                }
            }
            defaultGenomeBuilder.setUnchecked(speciesChromosome, AllelePair.both(IForestryApi.INSTANCE.getAlleleManager().registryAllele((ResourceLocation)id, speciesChromosome)));
            defaultGenomeBuilder.setRemainingDefault();
            IGenome defaultGenome = builder.buildGenome(defaultGenomeBuilder);
            return builder.createSpeciesFactory().create((ResourceLocation)id, this.type.cast(), defaultGenome, (ISpeciesBuilder)builder);
        });
        speciesChromosome.populate(allSpecies);
        ImmutableList.Builder mutations = new ImmutableList.Builder();
        for (Map.Entry<ResourceLocation, B> entry : this.species.getValues().entrySet()) {
            mutations.addAll(((ISpeciesBuilder)entry.getValue()).buildMutations(this.type, allSpecies));
        }
        return Pair.of(allSpecies, new MutationManager(mutations.build()));
    }
}

