/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import com.mojang.authlib.GameProfile;
import forestry.api.ForestryTags;
import forestry.api.arboriculture.IWoodType;
import forestry.api.genetics.IGenome;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.blocks.ForestryLeafType;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public enum VanillaWoodType implements IWoodType
{
    OAK(ForestryLeafType.OAK),
    SPRUCE(ForestryLeafType.SPRUCE),
    BIRCH(ForestryLeafType.BIRCH),
    JUNGLE(ForestryLeafType.JUNGLE),
    ACACIA(ForestryLeafType.ACACIA_VANILLA),
    DARK_OAK(ForestryLeafType.DARK_OAK),
    CHERRY(ForestryLeafType.CHERRY_VANILLA);

    public static final VanillaWoodType[] VALUES;
    private final ForestryLeafType leafType;
    public final TagKey<Block> fireproofBlockTag;
    public final TagKey<Item> fireproofItemTag;

    private VanillaWoodType(ForestryLeafType leafType) {
        this.leafType = leafType;
        String name = this.name().toLowerCase(Locale.ENGLISH);
        this.fireproofBlockTag = ForestryTags.blockTag("fireproof_" + name + "_logs");
        this.fireproofItemTag = ForestryTags.itemTag("fireproof_" + name + "_logs");
    }

    @Override
    public float getHardness() {
        return 2.0f;
    }

    @Override
    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean setDefaultLeaves(LevelAccessor level, BlockPos pos, IGenome genome, RandomSource rand, @Nullable GameProfile owner) {
        return ForestryWoodType.setDefaultLeavesImpl(level, pos, genome, rand, this.leafType);
    }

    public String m_7912_() {
        return this.toString();
    }

    static {
        VALUES = VanillaWoodType.values();
    }
}

