/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ForestryTreeSpecies;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.blocks.BlockExtendedLeaves;
import forestry.core.blocks.IColoredBlock;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockAbstractLeaves
extends BlockExtendedLeaves
implements IColoredBlock {
    public static final int FOLIAGE_COLOR_INDEX = 0;
    public static final int FRUIT_COLOR_INDEX = 2;

    public BlockAbstractLeaves() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60918_(SoundType.f_56740_).m_60977_().m_60955_().m_60922_(BlockUtil.IS_PARROT_OR_OCELOT).m_60960_(BlockUtil.NEVER).m_60971_(BlockUtil.NEVER));
    }

    @Nullable
    protected abstract ITree getTree(BlockGetter var1, BlockPos var2);

    public String m_7705_() {
        return "block.forestry.leaves";
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ITree tree = this.getTree(world, pos);
        if (tree == null) {
            return ItemStack.f_41583_;
        }
        ITreeSpecies species = tree.getSpecies();
        return species.getDecorativeLeaves();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        ITree tree = this.getTree((BlockGetter)world, pos);
        ITreeSpecies species = tree == null ? SpeciesUtil.getTreeSpecies(ForestryTreeSpecies.OAK) : tree.getGenome().getActiveValue(TreeChromosomes.SPECIES);
        ItemStack decorativeLeaves = species.getDecorativeLeaves();
        if (decorativeLeaves.m_41619_()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(decorativeLeaves);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        ITree tree = this.getTree(worldIn, pos);
        if (tree != null && tree.getSpecies().id().equals((Object)ForestryTreeSpecies.WILLOW)) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, worldIn, pos, context);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        Vec3 motion = entityIn.m_20184_();
        entityIn.m_20334_(motion.m_7096_() * 0.4, motion.m_7098_(), motion.m_7094_() * 0.4);
    }

    public final int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public final boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public final int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (face == Direction.DOWN) {
            return 20;
        }
        if (face != Direction.UP) {
            return 10;
        }
        return 5;
    }

    protected abstract void getLeafDrop(List<ItemStack> var1, Level var2, BlockPos var3, @Nullable GameProfile var4, float var5, int var6, LootParams.Builder var7);

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder context) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.m_49635_(state, context));
        GameProfile profile = null;
        Object object = context.m_287159_(LootContextParams.f_81455_);
        if (object instanceof Player) {
            Player player = (Player)object;
            profile = player.m_36316_();
        }
        ItemStack tool = (ItemStack)context.m_287159_(LootContextParams.f_81463_);
        BlockPos pos = BlockUtil.getPos(context);
        this.getLeafDrop(drops, (Level)context.m_287258_(), pos, profile, 1.0f, tool != null ? tool.getEnchantmentLevel(Enchantments.f_44987_) : 0, context);
        return drops;
    }

    public void m_214162_(BlockState pState, Level level, BlockPos pos, RandomSource rand) {
        super.m_214162_(pState, level, pos, rand);
        ITree tree = this.getTree((BlockGetter)level, pos);
        if (tree != null) {
            IGenome genome = tree.getGenome();
            genome.getActiveValue(TreeChromosomes.EFFECT).doAnimationEffect(genome, level, pos, rand);
        }
    }
}

